/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.federation.sssd.SSSDFederationProvider;
import org.keycloak.federation.sssd.api.Sssd;
import org.keycloak.federation.sssd.impl.PAMAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderFactory;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserFederationSyncResult;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class SSSDFederationProviderFactory
implements UserFederationProviderFactory,
EnvironmentDependentProviderFactory {
    private static final String PROVIDER_NAME = "sssd";
    private static final Logger logger = Logger.getLogger(SSSDFederationProvider.class);
    static final Set<String> configOptions = new HashSet<String>();

    public String getId() {
        return PROVIDER_NAME;
    }

    public UserFederationProvider getInstance(KeycloakSession session, UserFederationProviderModel model) {
        return new SSSDFederationProvider(session, model, this);
    }

    public Set<String> getConfigurationOptions() {
        return configOptions;
    }

    public UserFederationProvider create(KeycloakSession session) {
        return null;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public UserFederationSyncResult syncAllUsers(KeycloakSessionFactory sessionFactory, String realmId, UserFederationProviderModel model) {
        logger.info((Object)"Sync users not supported for this provider");
        return UserFederationSyncResult.empty();
    }

    public UserFederationSyncResult syncChangedUsers(KeycloakSessionFactory sessionFactory, String realmId, UserFederationProviderModel model, Date lastSync) {
        logger.info((Object)"Sync users not supported for this provider");
        return UserFederationSyncResult.empty();
    }

    protected PAMAuthenticator createPAMAuthenticator(String username, String ... factors) {
        return new PAMAuthenticator(username, factors);
    }

    public boolean isSupported() {
        return Sssd.isAvailable();
    }
}

