/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.ClientSessionCode;

public class IdentityProviderAuthenticator
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(IdentityProviderAuthenticator.class);

    public void authenticate(AuthenticationFlowContext context) {
        if (context.getUriInfo().getQueryParameters().containsKey((Object)"kc_idp_hint")) {
            String providerId = (String)context.getUriInfo().getQueryParameters().getFirst((Object)"kc_idp_hint");
            if (providerId == null || providerId.equals("")) {
                LOG.tracef("Skipping: kc_idp_hint query parameter is empty", new Object[0]);
                context.attempted();
            } else {
                LOG.tracef("Redirecting: %s set to %s", (Object)"kc_idp_hint", (Object)providerId);
                this.redirect(context, providerId);
            }
        } else if (context.getAuthenticatorConfig() != null && context.getAuthenticatorConfig().getConfig().containsKey("defaultProvider")) {
            String defaultProvider = (String)context.getAuthenticatorConfig().getConfig().get("defaultProvider");
            LOG.tracef("Redirecting: default provider set to %s", (Object)defaultProvider);
            this.redirect(context, defaultProvider);
        } else {
            LOG.tracef("No default provider set or %s query parameter provided", (Object)"kc_idp_hint");
            context.attempted();
        }
    }

    private void redirect(AuthenticationFlowContext context, String providerId) {
        List identityProviders = context.getRealm().getIdentityProviders();
        for (IdentityProviderModel identityProvider : identityProviders) {
            if (!identityProvider.isEnabled() || !providerId.equals(identityProvider.getAlias())) continue;
            String accessCode = new ClientSessionCode(context.getSession(), context.getRealm(), context.getClientSession()).getCode();
            Response response = Response.seeOther((URI)Urls.identityProviderAuthnRequest(context.getUriInfo().getBaseUri(), providerId, context.getRealm().getName(), accessCode)).build();
            LOG.debugf("Redirecting to %s", (Object)providerId);
            context.forceChallenge(response);
            return;
        }
        LOG.warnf("Provider not found or not enabled for realm %s", (Object)providerId);
        context.attempted();
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

