/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PolicyEvaluationService;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.PolicyProviderRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;

public class PolicyService {
    private final ResourceServer resourceServer;
    private final AuthorizationProvider authorization;
    private final RealmAuth auth;

    public PolicyService(ResourceServer resourceServer, AuthorizationProvider authorization, RealmAuth auth) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response create(PolicyRepresentation representation) {
        this.auth.requireManage();
        Policy policy = RepresentationToModel.toModel((PolicyRepresentation)representation, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        PolicyProviderAdminService resource = this.getPolicyProviderAdminResource(policy.getType(), this.authorization);
        if (resource != null) {
            try {
                resource.onCreate(policy);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        representation.setId(policy.getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)representation).build();
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response update(@PathParam(value="id") String id, PolicyRepresentation representation) {
        this.auth.requireManage();
        representation.setId(id);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Policy policy = storeFactory.getPolicyStore().findById(representation.getId());
        if (policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        policy = RepresentationToModel.toModel((PolicyRepresentation)representation, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        PolicyProviderAdminService resource = this.getPolicyProviderAdminResource(policy.getType(), this.authorization);
        if (resource != null) {
            try {
                resource.onUpdate(policy);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @Path(value="{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.auth.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        Policy policy = policyStore.findById(id);
        if (policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyProviderAdminService resource = this.getPolicyProviderAdminResource(policy.getType(), this.authorization);
        if (resource != null) {
            try {
                resource.onRemove(policy);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        policyStore.findDependentPolicies(id).forEach(dependentPolicy -> {
            if (dependentPolicy.getAssociatedPolicies().size() == 1) {
                policyStore.delete(dependentPolicy.getId());
            } else {
                dependentPolicy.removeAssociatedPolicy(policy);
            }
        });
        policyStore.delete(policy.getId());
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findById(@PathParam(value="id") String id) {
        this.auth.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Policy model = storeFactory.getPolicyStore().findById(id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Policy)model, (AuthorizationProvider)this.authorization)).build();
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response find(@QueryParam(value="name") String name) {
        this.auth.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (name == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Policy model = storeFactory.getPolicyStore().findByName(name, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Policy)model, (AuthorizationProvider)this.authorization)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findAll(@QueryParam(value="name") String name, @QueryParam(value="type") String type, @QueryParam(value="resource") String resource, @QueryParam(value="permission") Boolean permission, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        this.auth.requireView();
        HashMap<String, String[]> search = new HashMap<String, String[]>();
        if (name != null && !"".equals(name.trim())) {
            search.put("name", new String[]{name});
        }
        if (type != null && !"".equals(type.trim())) {
            search.put("type", new String[]{type});
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (resource != null && !"".equals(resource.trim())) {
            ArrayList policies = new ArrayList();
            HashMap<String, String[]> resourceSearch = new HashMap<String, String[]>();
            resourceSearch.put("name", new String[]{resource});
            storeFactory.getResourceStore().findByResourceServer(resourceSearch, this.resourceServer.getId(), -1, -1).forEach(resource1 -> {
                ResourceRepresentation resourceRepresentation = ModelToRepresentation.toRepresentation((Resource)resource1, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
                resourceRepresentation.getPolicies().forEach(policyRepresentation -> {
                    Policy associated = storeFactory.getPolicyStore().findById(policyRepresentation.getId());
                    policies.add(associated);
                    this.findAssociatedPolicies(associated, policies);
                });
            });
            if (policies.isEmpty()) {
                return Response.ok(Collections.emptyList()).build();
            }
            search.put("id", (String[])policies.stream().map(Policy::getId).toArray(String[]::new));
        }
        if (permission != null) {
            search.put("permission", new String[]{permission.toString()});
        }
        return Response.ok(storeFactory.getPolicyStore().findByResourceServer(search, this.resourceServer.getId(), firstResult != null ? firstResult : -1, maxResult != null ? maxResult : 100).stream().map(policy -> ModelToRepresentation.toRepresentation((Policy)policy, (AuthorizationProvider)this.authorization)).collect(Collectors.toList())).build();
    }

    @Path(value="providers")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findPolicyProviders() {
        this.auth.requireView();
        return Response.ok(this.authorization.getProviderFactories().stream().map(provider -> {
            PolicyProviderRepresentation representation = new PolicyProviderRepresentation();
            representation.setName(provider.getName());
            representation.setGroup(provider.getGroup());
            representation.setType(provider.getId());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="evaluate")
    public PolicyEvaluationService getPolicyEvaluateResource() {
        this.auth.requireView();
        PolicyEvaluationService resource = new PolicyEvaluationService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="{policyType}")
    public Object getPolicyTypeResource(@PathParam(value="policyType") String policyType) {
        this.auth.requireView();
        return this.getPolicyProviderAdminResource(policyType, this.authorization);
    }

    private PolicyProviderAdminService getPolicyProviderAdminResource(String policyType, AuthorizationProvider authorization) {
        PolicyProviderFactory providerFactory = authorization.getProviderFactory(policyType);
        if (providerFactory != null) {
            return providerFactory.getAdminResource(this.resourceServer);
        }
        return null;
    }

    private void findAssociatedPolicies(Policy policy, List<Policy> policies) {
        policy.getAssociatedPolicies().forEach(associated -> {
            policies.add((Policy)associated);
            this.findAssociatedPolicies((Policy)associated, policies);
        });
    }
}

