/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.security.PublicKey;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.RSATokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.util.JsonSerialization;

public class AccessTokenIntrospectionProvider
implements TokenIntrospectionProvider {
    private final KeycloakSession session;
    private final TokenManager tokenManager;
    private final RealmModel realm;

    public AccessTokenIntrospectionProvider(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.tokenManager = new TokenManager();
    }

    public Response introspect(String token) {
        try {
            ObjectNode tokenMetadata;
            boolean valid = true;
            AccessToken toIntrospect = null;
            try {
                RSATokenVerifier verifier = RSATokenVerifier.create((String)token).realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
                PublicKey publicKey = this.session.keys().getPublicKey(this.realm, verifier.getHeader().getKeyId());
                if (publicKey == null) {
                    valid = false;
                } else {
                    verifier.publicKey(publicKey);
                    verifier.verify();
                    toIntrospect = verifier.getToken();
                }
            }
            catch (VerificationException e) {
                valid = false;
            }
            RealmModel realm = this.session.getContext().getRealm();
            if (valid && toIntrospect != null) {
                valid = this.tokenManager.isTokenValid(this.session, realm, toIntrospect);
            }
            if (valid) {
                tokenMetadata = JsonSerialization.createObjectNode(toIntrospect);
                tokenMetadata.put("client_id", toIntrospect.getIssuedFor());
                tokenMetadata.put("username", toIntrospect.getPreferredUsername());
            } else {
                tokenMetadata = JsonSerialization.createObjectNode();
            }
            tokenMetadata.put("active", valid);
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)tokenMetadata)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating token introspection response.", e);
        }
    }

    protected AccessToken toAccessToken(String token) {
        try {
            RSATokenVerifier verifier = RSATokenVerifier.create((String)token).realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
            PublicKey publicKey = this.session.keys().getPublicKey(this.realm, verifier.getHeader().getKeyId());
            verifier.publicKey(publicKey);
            return verifier.verify().getToken();
        }
        catch (VerificationException e) {
            throw new ErrorResponseException("invalid_request", "Invalid token.", Response.Status.UNAUTHORIZED);
        }
    }

    public void close() {
    }
}

