/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.UserCredentialStoreManager;
import org.keycloak.keys.DefaultKeyManager;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserFederationManager;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.UserCache;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.services.DefaultKeycloakContext;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.DefaultKeycloakTransactionManager;
import org.keycloak.storage.UserStorageManager;
import org.keycloak.storage.federated.UserFederatedStorageProvider;

public class DefaultKeycloakSession
implements KeycloakSession {
    private final DefaultKeycloakSessionFactory factory;
    private final Map<Integer, Provider> providers = new HashMap<Integer, Provider>();
    private final List<Provider> closable = new LinkedList<Provider>();
    private final DefaultKeycloakTransactionManager transactionManager;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private RealmProvider model;
    private UserProvider userModel;
    private UserStorageManager userStorageManager;
    private UserCredentialStoreManager userCredentialStorageManager;
    private UserSessionProvider sessionProvider;
    private UserFederationManager federationManager;
    private UserFederatedStorageProvider userFederatedStorageProvider;
    private KeycloakContext context;
    private KeyManager keyManager;

    public DefaultKeycloakSession(DefaultKeycloakSessionFactory factory) {
        this.factory = factory;
        this.transactionManager = new DefaultKeycloakTransactionManager(this);
        this.federationManager = new UserFederationManager((KeycloakSession)this);
        this.context = new DefaultKeycloakContext(this);
    }

    public KeycloakContext getContext() {
        return this.context;
    }

    private RealmProvider getRealmProvider() {
        CacheRealmProvider cache = this.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.getProvider(RealmProvider.class);
    }

    private UserProvider getUserProvider() {
        UserCache cache = this.getProvider(UserCache.class);
        if (cache != null) {
            return cache;
        }
        return this.getProvider(UserProvider.class);
    }

    public UserCache getUserCache() {
        return this.getProvider(UserCache.class);
    }

    public void enlistForClose(Provider provider) {
        this.closable.add(provider);
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public Object removeAttribute(String attribute) {
        return this.attributes.remove(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public KeycloakTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public KeycloakSessionFactory getKeycloakSessionFactory() {
        return this.factory;
    }

    public UserFederatedStorageProvider userFederatedStorage() {
        if (this.userFederatedStorageProvider == null) {
            this.userFederatedStorageProvider = this.getProvider(UserFederatedStorageProvider.class);
        }
        return this.userFederatedStorageProvider;
    }

    public UserProvider userLocalStorage() {
        return this.getProvider(UserProvider.class);
    }

    public UserProvider userStorageManager() {
        if (this.userStorageManager == null) {
            this.userStorageManager = new UserStorageManager(this);
        }
        return this.userStorageManager;
    }

    public UserCredentialManager userCredentialManager() {
        if (this.userCredentialStorageManager == null) {
            this.userCredentialStorageManager = new UserCredentialStoreManager(this);
        }
        return this.userCredentialStorageManager;
    }

    public UserProvider userStorage() {
        if (this.userModel == null) {
            this.userModel = this.getUserProvider();
        }
        return this.userModel;
    }

    public <T extends Provider> T getProvider(Class<T> clazz) {
        ProviderFactory<T> providerFactory;
        Integer hash = clazz.hashCode();
        Provider provider = this.providers.get(hash);
        if (provider == null && (providerFactory = this.factory.getProviderFactory(clazz)) != null) {
            provider = providerFactory.create((KeycloakSession)this);
            this.providers.put(hash, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> T getProvider(Class<T> clazz, String id) {
        ProviderFactory<T> providerFactory;
        Integer hash = clazz.hashCode() + id.hashCode();
        Provider provider = this.providers.get(hash);
        if (provider == null && (providerFactory = this.factory.getProviderFactory(clazz, id)) != null) {
            provider = providerFactory.create((KeycloakSession)this);
            this.providers.put(hash, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> T getProvider(Class<T> clazz, ComponentModel componentModel) {
        String modelId = componentModel.getProviderType() + "::" + componentModel.getId();
        Object found = this.getAttribute(modelId);
        if (found != null) {
            return (T)((Provider)clazz.cast(found));
        }
        ProviderFactory<T> providerFactory = this.factory.getProviderFactory(clazz, componentModel.getProviderId());
        if (providerFactory == null) {
            return null;
        }
        ComponentFactory componentFactory = (ComponentFactory)providerFactory;
        Provider provider = (Provider)componentFactory.create((KeycloakSession)this, componentModel);
        this.enlistForClose(provider);
        this.setAttribute(modelId, provider);
        return (T)provider;
    }

    public <T extends Provider> Set<String> listProviderIds(Class<T> clazz) {
        return this.factory.getAllProviderIds(clazz);
    }

    public <T extends Provider> Set<T> getAllProviders(Class<T> clazz) {
        HashSet<T> providers = new HashSet<T>();
        for (String id : this.listProviderIds(clazz)) {
            providers.add(this.getProvider(clazz, id));
        }
        return providers;
    }

    public Class<? extends Provider> getProviderClass(String providerClassName) {
        return this.factory.getProviderClass(providerClassName);
    }

    public RealmProvider realms() {
        if (this.model == null) {
            this.model = this.getRealmProvider();
        }
        return this.model;
    }

    public UserFederationManager users() {
        return this.federationManager;
    }

    public UserSessionProvider sessions() {
        if (this.sessionProvider == null) {
            this.sessionProvider = this.getProvider(UserSessionProvider.class);
        }
        return this.sessionProvider;
    }

    public KeyManager keys() {
        if (this.keyManager == null) {
            this.keyManager = new DefaultKeyManager(this);
        }
        return this.keyManager;
    }

    public void close() {
        for (Provider p : this.providers.values()) {
            try {
                p.close();
            }
            catch (Exception exception) {}
        }
        for (Provider p : this.closable) {
            try {
                p.close();
            }
            catch (Exception exception) {}
        }
    }
}

