/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import java.io.Serializable;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.picketlink.Identity;
import org.picketlink.annotations.PicketLink;
import org.picketlink.authentication.AuthenticationException;
import org.picketlink.authentication.Authenticator;
import org.picketlink.authentication.LockedAccountException;
import org.picketlink.authentication.UnexpectedCredentialException;
import org.picketlink.authentication.UserAlreadyLoggedInException;
import org.picketlink.authentication.event.AlreadyLoggedInEvent;
import org.picketlink.authentication.event.LockedAccountEvent;
import org.picketlink.authentication.event.LoggedInEvent;
import org.picketlink.authentication.event.LoginFailedEvent;
import org.picketlink.authentication.event.PostAuthenticateEvent;
import org.picketlink.authentication.event.PostLoggedOutEvent;
import org.picketlink.authentication.event.PreAuthenticateEvent;
import org.picketlink.authentication.event.PreLoggedOutEvent;
import org.picketlink.authentication.internal.IdmAuthenticator;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.permission.spi.PermissionResolver;
import org.picketlink.internal.CDIEventBridge;
import org.picketlink.log.BaseLog;

public abstract class AbstractIdentity
implements Identity {
    private static final long serialVersionUID = 8655816330461907668L;
    @Inject
    private CDIEventBridge eventBridge;
    @Inject
    private DefaultLoginCredentials loginCredential;
    @Inject
    @PicketLink
    private Instance<Authenticator> authenticatorInstance;
    @Inject
    private Instance<IdmAuthenticator> idmAuthenticatorInstance;
    @Inject
    private transient PermissionResolver permissionResolver;
    private boolean authenticating;
    private Account account;

    public boolean isLoggedIn() {
        return this.account != null;
    }

    public Account getAccount() {
        return this.account;
    }

    public Identity.AuthenticationResult login() {
        try {
            if (BaseLog.AUTHENTICATION_LOGGER.isDebugEnabled()) {
                BaseLog.AUTHENTICATION_LOGGER.debugf("Performing authentication using credentials [%s]. User id is [%s].", this.loginCredential.getCredential(), (Object)this.loginCredential.getUserId());
            }
            if (this.isLoggedIn()) {
                throw new UserAlreadyLoggedInException("active agent: " + this.account.toString());
            }
            Account validatedAccount = this.authenticate();
            if (validatedAccount != null) {
                if (!validatedAccount.isEnabled()) {
                    throw new LockedAccountException("Account [" + validatedAccount + "] is disabled.");
                }
                this.handleSuccessfulLoginAttempt(validatedAccount);
                Identity.AuthenticationResult authenticationResult = Identity.AuthenticationResult.SUCCESS;
                return authenticationResult;
            }
            this.handleUnsuccesfulLoginAttempt(null);
            Identity.AuthenticationResult authenticationResult = Identity.AuthenticationResult.FAILED;
            return authenticationResult;
        }
        catch (Throwable e) {
            this.handleUnsuccesfulLoginAttempt(e);
            if (AuthenticationException.class.isInstance(e)) {
                throw (AuthenticationException)e;
            }
            throw new AuthenticationException("Login failed with a unexpected error.", e);
        }
        finally {
            if (BaseLog.AUTHENTICATION_LOGGER.isDebugEnabled()) {
                BaseLog.AUTHENTICATION_LOGGER.debugf("Authentication is finished using credentials [%s]. User id is [%s].", this.loginCredential.getCredential(), (Object)this.loginCredential.getUserId());
            }
        }
    }

    protected void handleSuccessfulLoginAttempt(Account validatedAccount) {
        BaseLog.AUTHENTICATION_LOGGER.debugf("Authentication was successful for credentials [%s]. User id is [%s].", this.loginCredential.getCredential(), (Object)this.loginCredential.getUserId());
        this.account = validatedAccount;
        this.eventBridge.fireEvent(new LoggedInEvent());
    }

    protected void handleUnsuccesfulLoginAttempt(Throwable e) {
        if (e != null && !UnexpectedCredentialException.class.isInstance(e)) {
            if (UserAlreadyLoggedInException.class.isInstance(e)) {
                this.eventBridge.fireEvent(new AlreadyLoggedInEvent());
            } else if (LockedAccountException.class.isInstance(e)) {
                this.eventBridge.fireEvent(new LockedAccountEvent());
            }
        }
        if (BaseLog.AUTHENTICATION_LOGGER.isDebugEnabled()) {
            BaseLog.AUTHENTICATION_LOGGER.debugf("Authentication failed for credentials [%s]. User id is [%s].", this.loginCredential.getCredential(), (Object)this.loginCredential.getUserId(), (Object)e);
        }
        this.eventBridge.fireEvent(new LoginFailedEvent(e));
    }

    protected Account authenticate() throws AuthenticationException {
        Account validatedAccount = null;
        if (this.authenticating) {
            this.authenticating = false;
            throw new IllegalStateException("Authentication already in progress.");
        }
        try {
            Authenticator authenticator;
            this.authenticating = true;
            this.eventBridge.fireEvent(new PreAuthenticateEvent());
            Authenticator authenticator2 = authenticator = this.authenticatorInstance.isUnsatisfied() ? (Authenticator)this.idmAuthenticatorInstance.get() : (Authenticator)this.authenticatorInstance.get();
            if (authenticator == null) {
                throw new AuthenticationException("No Authenticator has been configured.");
            }
            if (BaseLog.AUTHENTICATION_LOGGER.isDebugEnabled()) {
                BaseLog.AUTHENTICATION_LOGGER.debugf("Authentication is going to be performed by authenticator [%s]", (Object)authenticator);
            }
            authenticator.authenticate();
            if (authenticator.getStatus() == null) {
                throw new AuthenticationException("Authenticator must return a valid authentication status");
            }
            if (authenticator.getStatus() == Authenticator.AuthenticationStatus.SUCCESS) {
                validatedAccount = authenticator.getAccount();
                this.postAuthenticate(authenticator);
            }
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new AuthenticationException("Authentication failed.", ex);
        }
        finally {
            this.authenticating = false;
        }
        return validatedAccount;
    }

    protected void postAuthenticate(Authenticator authenticator) {
        authenticator.postAuthenticate();
        if (!authenticator.getStatus().equals((Object)Authenticator.AuthenticationStatus.SUCCESS)) {
            return;
        }
        this.eventBridge.fireEvent(new PostAuthenticateEvent());
    }

    public void logout() {
        this.logout(true);
    }

    protected void logout(boolean invalidateLoginCredential) {
        if (this.isLoggedIn()) {
            this.eventBridge.fireEvent(new PreLoggedOutEvent(this.account));
            PostLoggedOutEvent postLoggedOutEvent = new PostLoggedOutEvent(this.account);
            this.unAuthenticate(invalidateLoginCredential);
            this.eventBridge.fireEvent(postLoggedOutEvent);
        }
    }

    private void unAuthenticate(boolean invalidateLoginCredential) {
        this.account = null;
        if (invalidateLoginCredential) {
            this.loginCredential.invalidate();
        }
    }

    public boolean hasPermission(Object resource, String operation) {
        return this.isLoggedIn() && this.permissionResolver.resolvePermission((IdentityType)this.account, resource, operation);
    }

    public boolean hasPermission(Class<?> resourceClass, Serializable identifier, String operation) {
        return this.isLoggedIn() && this.permissionResolver.resolvePermission((IdentityType)this.account, resourceClass, identifier, operation);
    }
}

