/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.idm.Account;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.wildfly.extension.undertow.security.WebUtil;

public class AuditNotificationReceiver
implements NotificationReceiver {
    private final AuditManager auditManager;

    public AuditNotificationReceiver(AuditManager auditManager) {
        this.auditManager = auditManager;
    }

    public void handleNotification(SecurityNotification notification) {
        SecurityNotification.EventType event = notification.getEventType();
        if (event == SecurityNotification.EventType.AUTHENTICATED || event == SecurityNotification.EventType.FAILED_AUTHENTICATION) {
            ServletRequest hsr;
            AuditEvent auditEvent = new AuditEvent(event == SecurityNotification.EventType.AUTHENTICATED ? "Success" : "Failure");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            Account account = notification.getAccount();
            if (account != null) {
                ctxMap.put("principal", account.getPrincipal().getName());
            }
            ctxMap.put("message", notification.getMessage());
            ServletRequestContext src = (ServletRequestContext)notification.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            if (src != null && (hsr = src.getServletRequest()) instanceof HttpServletRequest) {
                ctxMap.put("request", WebUtil.deriveUsefulInfo((HttpServletRequest)hsr));
            }
            ctxMap.put("Source", this.getClass().getCanonicalName());
            auditEvent.setContextMap(ctxMap);
            this.auditManager.audit(auditEvent);
        }
    }
}

