/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.List;
import javax.naming.AuthenticationException;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.user.SynchronizationResult;

public class LDAPStorageMapperBridge
implements LDAPStorageMapper {
    private final AbstractLDAPStorageMapperFactory factory;

    public LDAPStorageMapperBridge(AbstractLDAPStorageMapperFactory factory) {
        this.factory = factory;
    }

    @Override
    public SynchronizationResult syncDataFromFederationProviderToKeycloak(ComponentModel mapperModel, LDAPStorageProvider federationProvider, KeycloakSession session, RealmModel realm) {
        return this.getDelegate(mapperModel, federationProvider, realm).syncDataFromFederationProviderToKeycloak();
    }

    @Override
    public SynchronizationResult syncDataFromKeycloakToFederationProvider(ComponentModel mapperModel, LDAPStorageProvider federationProvider, KeycloakSession session, RealmModel realm) {
        return this.getDelegate(mapperModel, federationProvider, realm).syncDataFromKeycloakToFederationProvider();
    }

    @Override
    public void onImportUserFromLDAP(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        this.getDelegate(mapperModel, ldapProvider, realm).onImportUserFromLDAP(ldapUser, user, isCreate);
    }

    @Override
    public void onRegisterUserToLDAP(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        this.getDelegate(mapperModel, ldapProvider, realm).onRegisterUserToLDAP(ldapUser, localUser);
    }

    @Override
    public UserModel proxy(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        return this.getDelegate(mapperModel, ldapProvider, realm).proxy(ldapUser, delegate);
    }

    @Override
    public void beforeLDAPQuery(ComponentModel mapperModel, LDAPQuery query) {
        this.getDelegate(mapperModel, query.getLdapProvider(), null).beforeLDAPQuery(query);
    }

    @Override
    public List<UserModel> getGroupMembers(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        return this.getDelegate(mapperModel, ldapProvider, realm).getGroupMembers(group, firstResult, maxResults);
    }

    @Override
    public boolean onAuthenticationFailure(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, LDAPObject ldapUser, UserModel user, AuthenticationException ldapException, RealmModel realm) {
        return this.getDelegate(mapperModel, ldapProvider, realm).onAuthenticationFailure(ldapUser, user, ldapException);
    }

    private AbstractLDAPStorageMapper getDelegate(ComponentModel mapperModel, LDAPStorageProvider federationProvider, RealmModel realm) {
        LDAPStorageProvider ldapProvider = federationProvider;
        return this.factory.createMapper(mapperModel, ldapProvider, realm);
    }

    public void close() {
    }
}

