/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapperConfig;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;

public enum MembershipType {
    DN{

        @Override
        public Set<LDAPDn> getLDAPSubgroups(GroupLDAPStorageMapper groupMapper, LDAPObject ldapGroup) {
            CommonLDAPGroupMapperConfig config = groupMapper.getConfig();
            return this.getLDAPMembersWithParent(ldapGroup, config.getMembershipLdapAttribute(), LDAPDn.fromString(config.getLDAPGroupsDn()));
        }

        protected Set<LDAPDn> getLDAPMembersWithParent(LDAPObject ldapGroup, String membershipLdapAttribute, LDAPDn requiredParentDn) {
            Set<String> allMemberships = LDAPUtils.getExistingMemberships(membershipLdapAttribute, ldapGroup);
            HashSet<LDAPDn> result = new HashSet<LDAPDn>();
            for (String membership : allMemberships) {
                LDAPDn childDn = LDAPDn.fromString(membership);
                if (!childDn.isDescendantOf(requiredParentDn)) continue;
                result.add(childDn);
            }
            return result;
        }

        @Override
        public List<UserModel> getGroupMembers(GroupLDAPStorageMapper groupMapper, LDAPObject ldapGroup, int firstResult, int maxResults) {
            RealmModel realm = groupMapper.getRealm();
            LDAPStorageProvider ldapProvider = groupMapper.getLdapProvider();
            CommonLDAPGroupMapperConfig config = groupMapper.getConfig();
            LDAPDn usersDn = LDAPDn.fromString(ldapProvider.getLdapIdentityStore().getConfig().getUsersDn());
            Set<LDAPDn> userDns = this.getLDAPMembersWithParent(ldapGroup, config.getMembershipLdapAttribute(), usersDn);
            if (userDns == null) {
                return Collections.emptyList();
            }
            if (userDns.size() <= firstResult) {
                return Collections.emptyList();
            }
            List<LDAPDn> dns = new ArrayList<LDAPDn>(userDns);
            int max = Math.min(dns.size(), firstResult + maxResults);
            dns = dns.subList(firstResult, max);
            LinkedList<String> usernames = new LinkedList<String>();
            LDAPConfig ldapConfig = ldapProvider.getLdapIdentityStore().getConfig();
            if (ldapConfig.getUsernameLdapAttribute().equals(ldapConfig.getRdnLdapAttribute())) {
                for (LDAPDn userDn : dns) {
                    String username = userDn.getFirstRdnAttrValue();
                    usernames.add(username);
                }
            } else {
                LDAPQuery query = LDAPUtils.createQueryForUserSearch(ldapProvider, realm);
                LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
                Condition[] orSubconditions = new Condition[dns.size()];
                int index = 0;
                for (LDAPDn userDn : dns) {
                    Condition condition;
                    orSubconditions[index] = condition = conditionsBuilder.equal(userDn.getFirstRdnAttrName(), userDn.getFirstRdnAttrValue());
                    ++index;
                }
                Condition orCondition = conditionsBuilder.orCondition(orSubconditions);
                query.addWhereCondition(orCondition);
                List<LDAPObject> ldapUsers = query.getResultList();
                for (LDAPObject ldapUser : ldapUsers) {
                    String username = LDAPUtils.getUsername(ldapUser, ldapConfig);
                    usernames.add(username);
                }
            }
            return ldapProvider.loadUsersByUsernames(usernames, realm);
        }
    }
    ,
    UID{

        @Override
        public Set<LDAPDn> getLDAPSubgroups(GroupLDAPStorageMapper groupMapper, LDAPObject ldapGroup) {
            return Collections.emptySet();
        }

        @Override
        public List<UserModel> getGroupMembers(GroupLDAPStorageMapper groupMapper, LDAPObject ldapGroup, int firstResult, int maxResults) {
            String memberAttrName = groupMapper.getConfig().getMembershipLdapAttribute();
            Set<String> memberUids = LDAPUtils.getExistingMemberships(memberAttrName, ldapGroup);
            if (memberUids == null || memberUids.size() <= firstResult) {
                return Collections.emptyList();
            }
            List<String> uids = new ArrayList<String>(memberUids);
            int max = Math.min(memberUids.size(), firstResult + maxResults);
            uids = uids.subList(firstResult, max);
            return groupMapper.getLdapProvider().loadUsersByUsernames(uids, groupMapper.getRealm());
        }
    };


    public abstract Set<LDAPDn> getLDAPSubgroups(GroupLDAPStorageMapper var1, LDAPObject var2);

    public abstract List<UserModel> getGroupMembers(GroupLDAPStorageMapper var1, LDAPObject var2, int var3, int var4);
}

