/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import java.util.Map;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MigrateTo1_8_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.8.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        List realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            List federationProviders = realm.getUserFederationProviders();
            for (UserFederationProviderModel fedProvider : federationProviders) {
                Map config;
                if (!fedProvider.getProviderName().equals("ldap") || !this.isActiveDirectory(config = fedProvider.getConfig()) || realm.getUserFederationMapperByName(fedProvider.getId(), "MSAD account controls") != null) continue;
                UserFederationMapperModel mapperModel = KeycloakModelUtils.createUserFederationMapperModel("MSAD account controls", fedProvider.getId(), "msad-user-account-control-mapper", new String[0]);
                realm.addUserFederationMapper(mapperModel);
            }
        }
    }

    private boolean isActiveDirectory(Map<String, String> ldapConfig) {
        String vendor = ldapConfig.get("vendor");
        return vendor != null && vendor.equals("ad");
    }
}

