/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.exception.impl;

import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LogErrorHandler
implements ErrorHandler {
    private static final Log log = LoggerFactory.make();

    @Override
    public void handle(ErrorContext context) {
        List<LuceneWork> failingOperations = context.getFailingOperations();
        LuceneWork primaryFailure = context.getOperationAtFault();
        Throwable exceptionThatOccurred = context.getThrowable();
        StringBuilder errorMsg = new StringBuilder();
        if (exceptionThatOccurred != null) {
            errorMsg.append("Exception occurred ").append(exceptionThatOccurred).append("\n");
        }
        if (primaryFailure != null) {
            errorMsg.append("Primary Failure:\n");
            LogErrorHandler.appendFailureMessage(errorMsg, primaryFailure);
        }
        if (!failingOperations.isEmpty()) {
            errorMsg.append("Subsequent failures:\n");
            for (LuceneWork workThatFailed : failingOperations) {
                LogErrorHandler.appendFailureMessage(errorMsg, workThatFailed);
            }
        }
        this.handleException(errorMsg.toString(), exceptionThatOccurred);
    }

    public static final void appendFailureMessage(StringBuilder message, LuceneWork workThatFailed) {
        message.append("\tEntity ").append(workThatFailed.getEntityClass().getName()).append(" ").append(" Id ").append(workThatFailed.getIdInString()).append(" ").append(" Work Type ").append(" ").append(workThatFailed.getClass().getName()).append("\n");
    }

    @Override
    public void handleException(String errorMsg, Throwable exception) {
        log.exceptionOccurred(errorMsg, exception);
    }
}

