/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager;

import javax.resource.spi.TransactionSupport;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.connectionmanager.AbstractConnectionManager;
import org.jboss.jca.core.connectionmanager.NoTxConnectionManager;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.notx.NoTxConnectionManagerImpl;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.tx.TxConnectionManagerImpl;
import org.jboss.jca.core.spi.security.SubjectFactory;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;

public class ConnectionManagerFactory {
    public NoTxConnectionManager createNonTransactional(TransactionSupport.TransactionSupportLevel tsl, Pool pool, SubjectFactory subjectFactory, String securityDomain, boolean useCcm, CachedConnectionManager ccm, boolean sharable, boolean enlistment, boolean connectable, Boolean tracking, FlushStrategy flushStrategy, Integer allocationRetry, Long allocationRetryWaitMillis) {
        if (tsl == null) {
            throw new IllegalArgumentException("TransactionSupportLevel is null");
        }
        if (pool == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        if (flushStrategy == null) {
            throw new IllegalArgumentException("FlushStrategy is null");
        }
        NoTxConnectionManagerImpl cm = null;
        switch (tsl) {
            case NoTransaction: {
                cm = new NoTxConnectionManagerImpl();
                break;
            }
            case LocalTransaction: {
                throw new IllegalArgumentException("Transactional connection manager not supported");
            }
            case XATransaction: {
                throw new IllegalArgumentException("Transactional connection manager not supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown transaction support level " + tsl);
            }
        }
        this.setProperties(cm, pool, subjectFactory, securityDomain, useCcm, ccm, sharable, enlistment, connectable, tracking, null, flushStrategy, allocationRetry, allocationRetryWaitMillis, null);
        this.setNoTxProperties(cm);
        return cm;
    }

    public TxConnectionManager createTransactional(TransactionSupport.TransactionSupportLevel tsl, Pool pool, SubjectFactory subjectFactory, String securityDomain, boolean useCcm, CachedConnectionManager ccm, boolean sharable, boolean enlistment, boolean connectable, Boolean tracking, Boolean enlistmentTrace, FlushStrategy flushStrategy, Integer allocationRetry, Long allocationRetryWaitMillis, TransactionIntegration txIntegration, Boolean interleaving, Integer xaResourceTimeout, Boolean isSameRMOverride, Boolean wrapXAResource, Boolean padXid) {
        if (tsl == null) {
            throw new IllegalArgumentException("TransactionSupportLevel is null");
        }
        if (pool == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        if (txIntegration == null) {
            throw new IllegalArgumentException("TransactionIntegration is null");
        }
        if (flushStrategy == null) {
            throw new IllegalArgumentException("FlushStrategy is null");
        }
        TxConnectionManagerImpl cm = null;
        switch (tsl) {
            case NoTransaction: {
                throw new IllegalArgumentException("Non transactional connection manager not supported");
            }
            case LocalTransaction: {
                cm = new TxConnectionManagerImpl(txIntegration, true);
                break;
            }
            case XATransaction: {
                cm = new TxConnectionManagerImpl(txIntegration, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown transaction support level " + tsl);
            }
        }
        this.setProperties(cm, pool, subjectFactory, securityDomain, useCcm, ccm, sharable, enlistment, connectable, tracking, enlistmentTrace, flushStrategy, allocationRetry, allocationRetryWaitMillis, txIntegration.getTransactionManager());
        this.setTxProperties(cm, interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
        return cm;
    }

    private void setProperties(AbstractConnectionManager cm, Pool pool, SubjectFactory subjectFactory, String securityDomain, boolean useCcm, CachedConnectionManager ccm, boolean sharable, boolean enlistment, boolean connectable, Boolean tracking, Boolean enlistmentTrace, FlushStrategy flushStrategy, Integer allocationRetry, Long allocationRetryWaitMillis, TransactionManager tm) {
        pool.setConnectionManager(cm);
        cm.setPool(pool);
        cm.setSubjectFactory(subjectFactory);
        cm.setSecurityDomain(securityDomain);
        cm.setFlushStrategy(flushStrategy);
        if (allocationRetry != null) {
            cm.setAllocationRetry(allocationRetry);
        }
        if (allocationRetryWaitMillis != null) {
            cm.setAllocationRetryWaitMillis(allocationRetryWaitMillis);
        }
        if (useCcm) {
            cm.setCachedConnectionManager(ccm);
        }
        cm.setSharable(sharable);
        cm.setEnlistment(enlistment);
        cm.setConnectable(connectable);
        cm.setTracking(tracking);
        cm.setEnlistmentTrace(enlistmentTrace);
    }

    private void setNoTxProperties(NoTxConnectionManagerImpl cm) {
    }

    private void setTxProperties(TxConnectionManagerImpl cm, Boolean interleaving, Integer xaResourceTimeout, Boolean isSameRMOverride, Boolean wrapXAResource, Boolean padXid) {
        if (interleaving != null) {
            cm.setInterleaving(interleaving);
        }
        if (xaResourceTimeout != null) {
            cm.setXAResourceTimeout(xaResourceTimeout);
        }
        cm.setIsSameRMOverride(isSameRMOverride);
        if (wrapXAResource != null) {
            cm.setWrapXAResource(wrapXAResource);
        }
        if (padXid != null) {
            cm.setPadXid(padXid);
        }
    }
}

