/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.Iterator;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;

public class RoleUtils {
    public static boolean isMember(Set<GroupModel> groups, GroupModel targetGroup) {
        if (groups.contains(targetGroup)) {
            return true;
        }
        Iterator<GroupModel> iterator = groups.iterator();
        while (iterator.hasNext()) {
            GroupModel mapping;
            GroupModel child = mapping = iterator.next();
            while (child.getParent() != null) {
                if (child.getParent().equals(targetGroup)) {
                    return true;
                }
                child = child.getParent();
            }
        }
        return false;
    }

    public static boolean hasRole(Set<RoleModel> roles, RoleModel targetRole) {
        if (roles.contains(targetRole)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(targetRole)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRoleFromGroup(GroupModel group, RoleModel targetRole, boolean checkParentGroup) {
        if (group.hasRole(targetRole)) {
            return true;
        }
        if (checkParentGroup) {
            GroupModel parent = group.getParent();
            return parent != null && RoleUtils.hasRoleFromGroup(parent, targetRole, true);
        }
        return false;
    }

    public static boolean hasRoleFromGroup(Iterable<GroupModel> groups, RoleModel targetRole, boolean checkParentGroup) {
        if (groups == null) {
            return false;
        }
        return StreamSupport.stream(groups.spliterator(), false).anyMatch(group -> RoleUtils.hasRoleFromGroup(group, targetRole, checkParentGroup));
    }
}

