/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ClientTemplateAdapter;
import org.keycloak.models.mongo.keycloak.adapters.GroupAdapter;
import org.keycloak.models.mongo.keycloak.adapters.MigrationModelAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RealmAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoClientTemplateEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoGroupEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoMigrationModelEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class MongoRealmProvider
implements RealmProvider {
    private final MongoStoreInvocationContext invocationContext;
    private final KeycloakSession session;

    public MongoRealmProvider(KeycloakSession session, MongoStoreInvocationContext invocationContext) {
        this.session = session;
        this.invocationContext = invocationContext;
    }

    public void close() {
    }

    public MigrationModel getMigrationModel() {
        MongoMigrationModelEntity entity = this.getMongoStore().loadEntity(MongoMigrationModelEntity.class, "VERSION", this.invocationContext);
        if (entity == null) {
            entity = new MongoMigrationModelEntity();
            this.getMongoStore().insertEntity(entity, this.invocationContext);
        }
        return new MigrationModelAdapter(this.session, entity, this.invocationContext);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        MongoRealmEntity newRealm = new MongoRealmEntity();
        newRealm.setId(id);
        newRealm.setName(name);
        this.getMongoStore().insertEntity(newRealm, this.invocationContext);
        final RealmAdapter model = new RealmAdapter(this.session, newRealm, this.invocationContext);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmCreationEvent(){

            public RealmModel getCreatedRealm() {
                return model;
            }
        });
        return model;
    }

    public RealmModel getRealm(String id) {
        MongoRealmEntity realmEntity = this.getMongoStore().loadEntity(MongoRealmEntity.class, id, this.invocationContext);
        return realmEntity != null ? new RealmAdapter(this.session, realmEntity, this.invocationContext) : null;
    }

    public List<RealmModel> getRealms() {
        BasicDBObject query = new BasicDBObject();
        List<MongoRealmEntity> realms = this.getMongoStore().loadEntities(MongoRealmEntity.class, (DBObject)query, this.invocationContext);
        ArrayList<RealmModel> results = new ArrayList<RealmModel>();
        for (MongoRealmEntity realmEntity : realms) {
            RealmModel realm = this.session.realms().getRealm(realmEntity.getId());
            if (realm == null) continue;
            results.add(realm);
        }
        return results;
    }

    public RealmModel getRealmByName(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).get();
        MongoRealmEntity realm = this.getMongoStore().loadSingleEntity(MongoRealmEntity.class, query, this.invocationContext);
        if (realm == null) {
            return null;
        }
        return this.session.realms().getRealm(realm.getId());
    }

    public boolean removeRealm(String id) {
        final RealmModel realm = this.getRealm(id);
        if (realm == null) {
            return false;
        }
        this.session.users().preRemove(realm);
        boolean removed = this.getMongoStore().removeEntity(MongoRealmEntity.class, id, this.invocationContext);
        if (removed) {
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmRemovedEvent(){

                public RealmModel getRealm() {
                    return realm;
                }

                public KeycloakSession getKeycloakSession() {
                    return MongoRealmProvider.this.session;
                }
            });
        }
        return removed;
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        MongoRoleEntity role = this.getMongoStore().loadEntity(MongoRoleEntity.class, id, this.invocationContext);
        if (role == null) {
            return null;
        }
        if (role.getRealmId() != null && !role.getRealmId().equals(realm.getId())) {
            return null;
        }
        if (role.getClientId() != null && realm.getClientById(role.getClientId()) == null) {
            return null;
        }
        return new RoleAdapter(this.session, realm, role, null, this.invocationContext);
    }

    public GroupModel getGroupById(String id, RealmModel realm) {
        MongoGroupEntity group = this.getMongoStore().loadEntity(MongoGroupEntity.class, id, this.invocationContext);
        if (group == null) {
            return null;
        }
        if (group.getRealmId() != null && !group.getRealmId().equals(realm.getId())) {
            return null;
        }
        return new GroupAdapter(this.session, realm, group, this.invocationContext);
    }

    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        if (toParent != null && group.getId().equals(toParent.getId())) {
            return;
        }
        if (group.getParentId() != null) {
            group.getParent().removeChild(group);
        }
        group.setParent(toParent);
        if (toParent != null) {
            toParent.addChild(group);
        } else {
            this.session.realms().addTopLevelGroup(realm, group);
        }
    }

    public List<GroupModel> getGroups(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        List<MongoGroupEntity> groups = this.getMongoStore().loadEntities(MongoGroupEntity.class, query, this.invocationContext);
        if (groups == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<GroupModel> result = new LinkedList<GroupModel>();
        if (groups == null) {
            return result;
        }
        for (MongoGroupEntity group : groups) {
            result.add(this.getGroupById(group.getId(), realm));
        }
        return Collections.unmodifiableList(result);
    }

    public List<GroupModel> getTopLevelGroups(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).and("parentId").is(null).get();
        List<MongoGroupEntity> groups = this.getMongoStore().loadEntities(MongoGroupEntity.class, query, this.invocationContext);
        if (groups == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<GroupModel> result = new LinkedList<GroupModel>();
        if (groups == null) {
            return result;
        }
        for (MongoGroupEntity group : groups) {
            result.add(this.getGroupById(group.getId(), realm));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean removeGroup(RealmModel realm, GroupModel group) {
        this.session.users().preRemove(realm, group);
        realm.removeDefaultGroup(group);
        for (GroupModel subGroup : group.getSubGroups()) {
            this.removeGroup(realm, subGroup);
        }
        this.moveGroup(realm, group, null);
        return this.getMongoStore().removeEntity(MongoGroupEntity.class, group.getId(), this.invocationContext);
    }

    public GroupModel createGroup(RealmModel realm, String name) {
        String id = KeycloakModelUtils.generateId();
        return this.createGroup(realm, id, name);
    }

    public GroupModel createGroup(RealmModel realm, String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        MongoGroupEntity group = new MongoGroupEntity();
        group.setId(id);
        group.setName(name);
        group.setRealmId(realm.getId());
        this.getMongoStore().insertEntity(group, this.invocationContext);
        return new GroupAdapter(this.session, realm, group, this.invocationContext);
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        subGroup.setParent(null);
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        MongoClientEntity appData = this.getMongoStore().loadEntity(MongoClientEntity.class, id, this.invocationContext);
        if (appData == null || !realm.getId().equals(appData.getRealmId())) {
            return null;
        }
        return new ClientAdapter(this.session, realm, appData, this.invocationContext);
    }

    public ClientModel addClient(RealmModel realm, String clientId) {
        return this.addClient(realm, KeycloakModelUtils.generateId(), clientId);
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        MongoClientEntity clientEntity = new MongoClientEntity();
        clientEntity.setId(id);
        clientEntity.setClientId(clientId);
        clientEntity.setRealmId(realm.getId());
        clientEntity.setEnabled(true);
        clientEntity.setStandardFlowEnabled(true);
        this.getMongoStore().insertEntity(clientEntity, this.invocationContext);
        if (clientId == null) {
            clientEntity.setClientId(clientEntity.getId());
            this.getMongoStore().updateEntity(clientEntity, this.invocationContext);
        }
        final ClientAdapter model = new ClientAdapter(this.session, realm, clientEntity, this.invocationContext);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ClientCreationEvent(){

            public ClientModel getCreatedClient() {
                return model;
            }
        });
        return model;
    }

    public List<ClientModel> getClients(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        List<MongoClientEntity> clientEntities = this.getMongoStore().loadEntities(MongoClientEntity.class, query, this.invocationContext);
        if (clientEntities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ClientModel> result = new ArrayList<ClientModel>();
        for (MongoClientEntity clientEntity : clientEntities) {
            result.add(this.session.realms().getClientById(clientEntity.getId(), realm));
        }
        return Collections.unmodifiableList(result);
    }

    public RoleModel addRealmRole(RealmModel realm, String name) {
        return this.addRealmRole(realm, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        MongoRoleEntity roleEntity = new MongoRoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setRealmId(realm.getId());
        this.getMongoStore().insertEntity(roleEntity, this.invocationContext);
        return new RoleAdapter(this.session, realm, roleEntity, (RoleContainerModel)realm, this.invocationContext);
    }

    public Set<RoleModel> getRealmRoles(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        List<MongoRoleEntity> roles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        if (roles == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (MongoRoleEntity role : roles) {
            result.add(this.session.realms().getRoleById(role.getId(), realm));
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<RoleModel> getClientRoles(RealmModel realm, ClientModel client) {
        DBObject query = new QueryBuilder().and("clientId").is((Object)client.getId()).get();
        List<MongoRoleEntity> roles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (MongoRoleEntity role : roles) {
            result.add(this.session.realms().getRoleById(role.getId(), realm));
        }
        return result;
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("realmId").is((Object)realm.getId()).get();
        MongoRoleEntity role = this.getMongoStore().loadSingleEntity(MongoRoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return this.session.realms().getRoleById(role.getId(), realm);
    }

    public RoleModel getClientRole(RealmModel realm, ClientModel client, String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("clientId").is((Object)client.getId()).get();
        MongoRoleEntity role = this.getMongoStore().loadSingleEntity(MongoRoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return this.session.realms().getRoleById(role.getId(), realm);
    }

    public RoleModel addClientRole(RealmModel realm, ClientModel client, String name) {
        return this.addClientRole(realm, client, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addClientRole(RealmModel realm, ClientModel client, String id, String name) {
        MongoRoleEntity roleEntity = new MongoRoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setClientId(client.getId());
        this.getMongoStore().insertEntity(roleEntity, this.invocationContext);
        return new RoleAdapter(this.session, realm, roleEntity, (RoleContainerModel)client, this.invocationContext);
    }

    public boolean removeRole(RealmModel realm, RoleModel role) {
        this.session.users().preRemove(realm, role);
        RoleContainerModel container = role.getContainer();
        if (container.getDefaultRoles().contains(role.getName())) {
            container.removeDefaultRoles(new String[]{role.getName()});
        }
        return this.getMongoStore().removeEntity(MongoRoleEntity.class, role.getId(), this.invocationContext);
    }

    public boolean removeClient(String id, RealmModel realm) {
        if (id == null) {
            return false;
        }
        final ClientModel client = this.getClientById(id, realm);
        if (client == null) {
            return false;
        }
        this.session.users().preRemove(realm, client);
        boolean removed = this.getMongoStore().removeEntity(MongoClientEntity.class, id, this.invocationContext);
        if (removed) {
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ClientRemovedEvent(){

                public ClientModel getClient() {
                    return client;
                }

                public KeycloakSession getKeycloakSession() {
                    return MongoRealmProvider.this.session;
                }
            });
        }
        return removed;
    }

    public ClientModel getClientByClientId(String clientId, RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).and("clientId").is((Object)clientId).get();
        MongoClientEntity appEntity = this.getMongoStore().loadSingleEntity(MongoClientEntity.class, query, this.invocationContext);
        if (appEntity == null) {
            return null;
        }
        return this.session.realms().getClientById(appEntity.getId(), realm);
    }

    public ClientTemplateModel getClientTemplateById(String id, RealmModel realm) {
        MongoClientTemplateEntity appData = this.getMongoStore().loadEntity(MongoClientTemplateEntity.class, id, this.invocationContext);
        if (appData == null || !realm.getId().equals(appData.getRealmId())) {
            return null;
        }
        return new ClientTemplateAdapter(this.session, realm, appData, this.invocationContext);
    }
}

