/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import java.util.Collection;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public final class KeycloakAdapterConfigService {
    static final KeycloakAdapterConfigService INSTANCE = new KeycloakAdapterConfigService();
    static final String DEPLOYMENT_NAME = "keycloak-server.war";
    static ModelNode fullConfig = new ModelNode();
    private String webContext;

    private KeycloakAdapterConfigService() {
    }

    void updateConfig(ModelNode operation, ModelNode config) {
        ModelNode newConfig;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        address = address.subAddress(1);
        ModelNode subNode = newConfig = fullConfig.clone();
        for (PathElement pathElement : address) {
            subNode = subNode.get(new String[]{pathElement.getKey(), pathElement.getValue()});
        }
        subNode.set(config.clone());
        for (Property prop : subNode.asPropertyList()) {
            if (prop.getValue().isDefined()) continue;
            subNode.remove(prop.getName());
        }
        fullConfig = newConfig;
    }

    ModelNode getConfig() {
        ModelNode copy = fullConfig.clone();
        copy.remove("web-context");
        this.massageScheduledTaskInterval(copy);
        this.massageMasterRealm(copy);
        this.massageTheme(copy);
        this.massageSpis(copy);
        return copy;
    }

    private void massageScheduledTaskInterval(ModelNode copy) {
        if (!copy.hasDefined("scheduled-task-intervale")) {
            return;
        }
        ModelNode taskInterval = copy.remove("scheduled-task-interval");
        copy.get(new String[]{"scheduled", "interval"}).set(taskInterval);
    }

    private void massageMasterRealm(ModelNode copy) {
        if (!copy.hasDefined("master-realm-name")) {
            return;
        }
        ModelNode master = copy.remove("master-realm-name");
        copy.get(new String[]{"admin", "realm"}).set(master);
    }

    private void massageTheme(ModelNode copy) {
        if (!copy.hasDefined("theme")) {
            return;
        }
        if (!copy.get("theme").hasDefined("defaults")) {
            return;
        }
        ModelNode themeDefaults = copy.get(new String[]{"theme", "defaults"});
        copy.get("theme").set(themeDefaults);
        if (copy.has(new String[]{"theme", "dir"})) {
            ModelNode dir = copy.get(new String[]{"theme", "dir"});
            copy.get(new String[]{"theme", "folder", "dir"}).set(dir);
            copy.get("theme").remove("dir");
        }
        if (copy.has(new String[]{"theme", "modules"})) {
            ModelNode modules = copy.get("theme").remove("modules");
            copy.get(new String[]{"theme", "module", "modules"}).set(modules);
        }
    }

    private void massageSpis(ModelNode copy) {
        if (!copy.hasDefined("spi")) {
            return;
        }
        ModelNode spis = copy.remove("spi");
        for (Property prop : spis.asPropertyList()) {
            ModelNode spi = prop.getValue();
            if (spi.has("provider")) {
                this.massageProviders(spi);
            }
            if (spi.has("default-provider")) {
                ModelNode defaultProvider = spi.remove("default-provider");
                spi.get("provider").set(defaultProvider);
            }
            copy.get(prop.getName()).set(spi);
        }
    }

    private void massageProviders(ModelNode spi) {
        if (!spi.hasDefined("provider")) {
            return;
        }
        ModelNode providers = spi.remove("provider");
        for (Property prop : providers.asPropertyList()) {
            ModelNode provider = prop.getValue();
            if (provider.has("properties")) {
                this.massageProviderProps(provider);
            }
            spi.get(prop.getName()).set(provider);
        }
    }

    private void massageProviderProps(ModelNode provider) {
        if (!provider.hasDefined("properties")) {
            return;
        }
        ModelNode providerProps = provider.remove("properties");
        for (Property prop : providerProps.asPropertyList()) {
            ModelNode value = prop.getValue();
            if (this.isArray(value.asString().trim())) {
                provider.get(prop.getName()).set((Collection)ModelNode.fromString((String)value.asString()).asList());
                continue;
            }
            provider.get(prop.getName()).set(value);
        }
    }

    private boolean isArray(String value) {
        return value.startsWith("[") && value.endsWith("]");
    }

    void setWebContext(String webContext) {
        this.webContext = webContext;
    }

    String getWebContext() {
        return this.webContext;
    }

    boolean isKeycloakServerDeployment(String deploymentName) {
        return DEPLOYMENT_NAME.equals(deploymentName);
    }
}

