/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.api.saml.v2.sig;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.parsers.ParserConfigurationException;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.util.SignatureUtilTransferObject;
import org.keycloak.saml.processing.core.util.XMLSignatureUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAML2Signature {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final String ID_ATTRIBUTE_NAME = "ID";
    private String signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";
    private Node sibling;
    private X509Certificate x509Certificate;

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setDigestMethod(String digestMethod) {
        this.digestMethod = digestMethod;
    }

    public void setNextSibling(Node sibling) {
        this.sibling = sibling;
    }

    public void setSignatureIncludeKeyInfo(boolean val) {
        if (!val) {
            XMLSignatureUtil.setIncludeKeyInfoInSignature(false);
        }
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public Document sign(Document doc, String referenceID, String keyId, KeyPair keyPair, String canonicalizationMethodType) throws ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        String referenceURI = "#" + referenceID;
        this.configureIdAttribute(doc);
        if (this.sibling != null) {
            SignatureUtilTransferObject dto = new SignatureUtilTransferObject();
            dto.setDocumentToBeSigned(doc);
            dto.setKeyId(keyId);
            dto.setKeyPair(keyPair);
            dto.setDigestMethod(this.digestMethod);
            dto.setSignatureMethod(this.signatureMethod);
            dto.setReferenceURI(referenceURI);
            dto.setNextSibling(this.sibling);
            if (this.x509Certificate != null) {
                dto.setX509Certificate(this.x509Certificate);
            }
            return XMLSignatureUtil.sign(dto, canonicalizationMethodType);
        }
        return XMLSignatureUtil.sign(doc, keyId, keyPair, this.digestMethod, this.signatureMethod, referenceURI, canonicalizationMethodType);
    }

    public void signSAMLDocument(Document samlDocument, String keyId, KeyPair keypair, String canonicalizationMethodType) throws ProcessingException {
        String id = samlDocument.getDocumentElement().getAttribute(ID_ATTRIBUTE_NAME);
        try {
            this.sign(samlDocument, id, keyId, keypair, canonicalizationMethodType);
        }
        catch (GeneralSecurityException | MarshalException | XMLSignatureException | ParserConfigurationException e) {
            throw new ProcessingException((Throwable)logger.signatureError(e));
        }
    }

    public boolean validate(Document signedDocument, KeyLocator keyLocator) throws ProcessingException {
        try {
            this.configureIdAttribute(signedDocument);
            return XMLSignatureUtil.validate(signedDocument, keyLocator);
        }
        catch (MarshalException | XMLSignatureException me) {
            throw new ProcessingException((Throwable)logger.signatureError(me));
        }
    }

    public Node getNextSiblingOfIssuer(Document doc) {
        NodeList nl = doc.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get());
        if (nl.getLength() > 0) {
            Node issuer = nl.item(0);
            return issuer.getNextSibling();
        }
        return null;
    }

    private void configureIdAttribute(Document document) {
        document.getDocumentElement().setIdAttribute(ID_ATTRIBUTE_NAME, true);
        NodeList nodes = document.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            ((Element)n).setIdAttribute(ID_ATTRIBUTE_NAME, true);
        }
    }
}

