/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.client;

import java.io.IOException;
import java.util.ArrayList;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.client.ClientPolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.util.JsonSerialization;

public class ClientPolicyProviderFactory
implements PolicyProviderFactory {
    private ClientPolicyProvider provider = new ClientPolicyProvider();

    public String getName() {
        return "Client";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProviderAdminService getAdminResource(ResourceServer resourceServer) {
        return null;
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RealmModel.ClientRemovedEvent) {
                KeycloakSession keycloakSession = ((RealmModel.ClientRemovedEvent)event).getKeycloakSession();
                AuthorizationProvider provider = (AuthorizationProvider)keycloakSession.getProvider(AuthorizationProvider.class);
                StoreFactory storeFactory = provider.getStoreFactory();
                PolicyStore policyStore = storeFactory.getPolicyStore();
                ClientModel removedClient = ((RealmModel.ClientRemovedEvent)event).getClient();
                ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
                ResourceServer resourceServer = resourceServerStore.findByClient(removedClient.getId());
                if (resourceServer != null) {
                    policyStore.findByType(this.getId(), resourceServer.getId()).forEach(policy -> {
                        ArrayList<String> clients = new ArrayList<String>();
                        for (String clientId : ClientPolicyProviderFactory.getClients(policy)) {
                            if (clientId.equals(removedClient.getId())) continue;
                            clients.add(clientId);
                        }
                        try {
                            if (clients.isEmpty()) {
                                policyStore.findDependentPolicies(policy.getId(), resourceServer.getId()).forEach(dependentPolicy -> dependentPolicy.removeAssociatedPolicy(policy));
                                policyStore.delete(policy.getId());
                            } else {
                                policy.getConfig().put("clients", JsonSerialization.writeValueAsString(clients));
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error while synchronizing clients with policy [" + policy.getName() + "].", e);
                        }
                    });
                }
            }
        });
    }

    public void close() {
    }

    public String getId() {
        return "client";
    }

    static String[] getClients(Policy policy) {
        String clients = (String)policy.getConfig().get("clients");
        if (clients != null) {
            try {
                return (String[])JsonSerialization.readValue((byte[])clients.getBytes(), String[].class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse clients [" + clients + "] from policy config [" + policy.getName() + "].", e);
            }
        }
        return new String[0];
    }
}

