/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Externalizable;
import java.util.HashSet;
import java.util.Set;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.factmodel.traits.AbstractTraitFactory;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.factmodel.traits.TraitTypeEnum;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.factmodel.traits.VirtualPropertyMode;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.KieComponentFactory;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.HierarchyEncoder;
import org.drools.core.util.TripleFactory;
import org.drools.core.util.TripleStore;
import org.kie.api.KieBase;
import org.mvel2.asm.Opcodes;

public class TraitFactory<T extends Thing<K>, K extends TraitableBean>
extends AbstractTraitFactory<T, K>
implements Opcodes,
Externalizable {
    private transient InternalKnowledgeBase kBase;
    private transient Set<String> runtimeClasses;

    public static void setMode(VirtualPropertyMode newMode, KieBase kBase) {
        KieComponentFactory rcf = ((InternalKnowledgeBase)kBase).getConfiguration().getComponentFactory();
        TraitFactory.setMode(newMode, rcf);
    }

    public static TraitFactory getTraitBuilderForKnowledgeBase(KieBase kb) {
        return ((InternalKnowledgeBase)kb).getConfiguration().getComponentFactory().getTraitFactory();
    }

    @Override
    protected Class<?> registerAndLoadTypeDefinition(String proxyName, byte[] proxy) throws ClassNotFoundException {
        this.registerRuntimeClass(proxyName);
        return this.kBase.registerAndLoadTypeDefinition(proxyName, proxy);
    }

    private void registerRuntimeClass(String proxyName) {
        if (this.runtimeClasses == null) {
            this.runtimeClasses = new HashSet<String>();
        }
        this.runtimeClasses.add(ClassUtils.convertClassToResourcePath(proxyName));
    }

    @Override
    protected ClassLoader getRootClassLoader() {
        return this.kBase.getRootClassLoader();
    }

    @Override
    protected KieComponentFactory getComponentFactory() {
        return this.kBase.getConfiguration().getComponentFactory();
    }

    @Override
    protected TraitRegistry getTraitRegistry() {
        return this.kBase.getTraitRegistry();
    }

    @Override
    protected HierarchyEncoder getHierarchyEncoder() {
        return this.getTraitRegistry().getHierarchy();
    }

    @Override
    protected TripleStore getTripleStore() {
        return this.kBase.getTripleStore();
    }

    @Override
    protected TripleFactory getTripleFactory() {
        return this.getComponentFactory().getTripleFactory();
    }

    @Override
    protected ClassFieldAccessorStore getClassFieldAccessorStore() {
        InternalKnowledgePackage traitPackage = this.kBase.getPackagesMap().get("org.drools.core.factmodel.traits.");
        if (traitPackage == null) {
            traitPackage = new KnowledgePackageImpl("org.drools.core.factmodel.traits.");
            traitPackage.setClassFieldAccessorCache(this.kBase.getClassFieldAccessorCache());
            this.kBase.getPackagesMap().put("org.drools.core.factmodel.traits.", traitPackage);
        }
        return traitPackage.getClassFieldAccessorStore();
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    public void setRuleBase(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
    }

    public static TraitTypeEnum determineTraitType(Object object) {
        if (object instanceof TraitProxy) {
            return TraitTypeEnum.TRAIT;
        }
        if (object instanceof CoreWrapper) {
            return TraitTypeEnum.WRAPPED_TRAITABLE;
        }
        if (object instanceof TraitableBean) {
            return TraitTypeEnum.TRAITABLE;
        }
        return TraitTypeEnum.LEGACY_TRAITABLE;
    }

    public boolean isRuntimeClass(String resourceName) {
        return this.runtimeClasses != null && this.runtimeClasses.contains(resourceName);
    }
}

