/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.transform;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.transform.InitialAttributeValueOperationContextAttachment;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LegacyPropertyWriteOperationTransformer
implements OperationTransformer {
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        if (operation.get("name").asString().equals("properties")) {
            ModelNode newValue;
            ModelNode initialValue;
            InitialAttributeValueOperationContextAttachment attachment = (InitialAttributeValueOperationContextAttachment)context.getAttachment(InitialAttributeValueOperationContextAttachment.INITIAL_VALUES_ATTACHMENT);
            assert (attachment != null);
            HashMap<String, String> undoAliases = new HashMap<String, String>();
            undoAliases.put("BINARY_KEYED_JDBC_STORE", "binary-jdbc");
            undoAliases.put("STORE", "custom");
            undoAliases.put("FILE_STORE", "file");
            undoAliases.put("MIXED_KEYED_JDBC_STORE", "mixed-jdbc");
            undoAliases.put("REMOTE_STORE", "remote");
            undoAliases.put("STRING_KEYED_JDBC_STORE", "string-jdbc");
            if (undoAliases.containsKey(address.getLastElement().getValue())) {
                address = address.subAddress(0, address.size() - 1).append("store", (String)undoAliases.get(address.getLastElement().getValue()));
            }
            if ((initialValue = attachment.getInitialValue(address, Operations.getAttributeName(operation))).equals(newValue = context.readResourceFromRoot(address).getModel().get("properties").clone()) || initialValue.isDefined() && initialValue.asPropertyList().isEmpty() && !newValue.isDefined()) {
                return new OperationTransformer.TransformedOperation(null, DEFAULT_REJECTION_POLICY, SUCCESSFUL_RESULT);
            }
            HashMap<String, ModelNode> oldMap = new HashMap<String, ModelNode>();
            if (initialValue.isDefined()) {
                for (Property property : initialValue.asPropertyList()) {
                    oldMap.put(property.getName(), property.getValue());
                }
            }
            PathAddress legacyAddress = Operations.getPathAddress(operation);
            ModelNode composite = new ModelNode();
            composite.get("operation").set("composite");
            composite.get("address").setEmptyList();
            if (newValue.isDefined()) {
                for (Property property : newValue.asPropertyList()) {
                    String key = property.getName();
                    ModelNode value = property.getValue();
                    if (!oldMap.containsKey(key)) {
                        ModelNode addOp = Util.createAddOperation((PathAddress)legacyAddress.append(new PathElement[]{PathElement.pathElement((String)"property", (String)key)}));
                        addOp.get("value").set(value);
                        composite.get("steps").add(addOp);
                        continue;
                    }
                    ModelNode oldPropValue = (ModelNode)oldMap.get(key);
                    if (!oldPropValue.equals(value)) {
                        ModelNode writeOp = Util.getWriteAttributeOperation((PathAddress)legacyAddress.append(new PathElement[]{PathElement.pathElement((String)"property", (String)key)}), (String)"value", (ModelNode)value);
                        composite.get("steps").add(writeOp);
                    }
                    oldMap.remove(key);
                }
            }
            for (Map.Entry entry : oldMap.entrySet()) {
                ModelNode removeOperation = Util.createRemoveOperation((PathAddress)legacyAddress.append(new PathElement[]{PathElement.pathElement((String)"property", (String)((String)entry.getKey()))}));
                composite.get("steps").add(removeOperation);
            }
            initialValue.set(newValue.clone());
            return new OperationTransformer.TransformedOperation(composite, OperationResultTransformer.ORIGINAL_RESULT);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }
}

