/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Set;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

public class UserFederationLinkRemovedEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    private String userId;
    private String realmId;
    private String identityProviderId;
    private String socialUserId;

    public static UserFederationLinkRemovedEvent create(String userId, String realmId, FederatedIdentityModel socialLink) {
        UserFederationLinkRemovedEvent event = new UserFederationLinkRemovedEvent();
        event.userId = userId;
        event.realmId = realmId;
        if (socialLink != null) {
            event.identityProviderId = socialLink.getIdentityProvider();
            event.socialUserId = socialLink.getUserId();
        }
        return event;
    }

    @Override
    public String getId() {
        return this.userId;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getSocialUserId() {
        return this.socialUserId;
    }

    public String toString() {
        return String.format("UserFederationLinkRemovedEvent [ userId=%s, identityProviderId=%s, socialUserId=%s ]", this.userId, this.identityProviderId, this.socialUserId);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.federatedIdentityLinkRemovedInvalidation(this.userId, this.realmId, this.identityProviderId, this.socialUserId, invalidations);
    }
}

