/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jboss.threads.JBossThreadFactory;
import org.jgroups.Address;
import org.jgroups.UnreachableException;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.dispatcher.SimpleCommandResponse;

public class LocalCommandDispatcher<C>
implements CommandDispatcher<C> {
    final C context;
    private final Node node;
    private final ExecutorService executor;

    public LocalCommandDispatcher(Node node, C context) {
        this(node, context, Executors.newCachedThreadPool(LocalCommandDispatcher.createThreadFactory()));
    }

    private static ThreadFactory createThreadFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup(LocalCommandDispatcher.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
    }

    public LocalCommandDispatcher(Node node, C context, ExecutorService executor) {
        this.node = node;
        this.context = context;
        this.executor = executor;
    }

    public <R> CommandResponse<R> executeOnNode(Command<R, C> command, Node node) {
        if (!this.node.equals(node)) {
            throw new UnreachableException((Address)null);
        }
        try {
            return new SimpleCommandResponse<Object>(command.execute(this.context));
        }
        catch (Throwable e) {
            return new SimpleCommandResponse(e);
        }
    }

    public <R> Map<Node, CommandResponse<R>> executeOnCluster(Command<R, C> command, Node ... excludedNodes) {
        HashMap<Node, CommandResponse<R>> results = new HashMap<Node, CommandResponse<R>>();
        if (excludedNodes == null || excludedNodes.length == 0 || !Arrays.asList(excludedNodes).contains(this.node)) {
            results.put(this.node, this.executeOnNode(command, this.node));
        }
        return results;
    }

    public <R> Future<R> submitOnNode(final Command<R, C> command, Node node) {
        Callable task = new Callable<R>(){

            @Override
            public R call() throws Exception {
                return command.execute(LocalCommandDispatcher.this.context);
            }
        };
        return this.executor.submit(task);
    }

    public <R> Map<Node, Future<R>> submitOnCluster(Command<R, C> command, Node ... excludedNodes) {
        HashMap<Node, Future<R>> results = new HashMap<Node, Future<R>>();
        if (excludedNodes == null || excludedNodes.length == 0 || !Arrays.asList(excludedNodes).contains(this.node)) {
            results.put(this.node, this.submitOnNode(command, this.node));
        }
        return results;
    }

    public void close() {
        this.executor.shutdown();
    }
}

