/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.drools;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicy;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicyAdminResource;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;

public class DroolsPolicyProviderFactory
implements PolicyProviderFactory {
    private KieServices ks;
    private final Map<String, DroolsPolicy> containers = Collections.synchronizedMap(new HashMap());
    private DroolsPolicyProvider provider = new DroolsPolicyProvider(policy -> {
        if (!this.containers.containsKey(policy.getId())) {
            Map<String, DroolsPolicy> map = this.containers;
            synchronized (map) {
                this.update((Policy)policy);
            }
        }
        return this.containers.get(policy.getId());
    });

    public String getName() {
        return "Rule";
    }

    public String getGroup() {
        return "Rule Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProviderAdminService getAdminResource(ResourceServer resourceServer) {
        return new DroolsPolicyAdminResource(resourceServer, this);
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public void init(Config.Scope config) {
        this.ks = KieServices.Factory.get();
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        this.containers.values().forEach(DroolsPolicy::dispose);
        this.containers.clear();
    }

    public String getId() {
        return "drools";
    }

    void update(Policy policy) {
        this.remove(policy);
        this.containers.put(policy.getId(), new DroolsPolicy(this.ks, policy));
    }

    void remove(Policy policy) {
        DroolsPolicy holder = this.containers.remove(policy.getId());
        if (holder != null) {
            holder.dispose();
        }
    }

    KieContainer getKieContainer(String groupId, String artifactId, String version) {
        return this.ks.newKieContainer(this.ks.newReleaseId(groupId, artifactId, version));
    }
}

