/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.Constants;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.transaction.JtaTransactionManagerLookup;

public final class KeycloakModelUtils {
    private KeycloakModelUtils() {
    }

    public static String generateId() {
        return UUID.randomUUID().toString();
    }

    public static String generateSecret() {
        return KeycloakModelUtils.generateSecret(32);
    }

    public static String generateSecret(int bytes) {
        byte[] buf = new byte[bytes];
        new SecureRandom().nextBytes(buf);
        return Base64Url.encode((byte[])buf);
    }

    public static PublicKey getPublicKey(String publicKeyPem) {
        if (publicKeyPem != null) {
            try {
                return PemUtils.decodePublicKey((String)publicKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static X509Certificate getCertificate(String cert) {
        if (cert != null) {
            try {
                return PemUtils.decodeCertificate((String)cert);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static PrivateKey getPrivateKey(String privateKeyPem) {
        if (privateKeyPem != null) {
            try {
                return PemUtils.decodePrivateKey((String)privateKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Key getSecretKey(String secret) {
        return secret != null ? new SecretKeySpec(secret.getBytes(), "HmacSHA256") : null;
    }

    public static String getPemFromKey(Key key) {
        return PemUtils.encodeKey((Key)key);
    }

    public static String getPemFromCertificate(X509Certificate certificate) {
        return PemUtils.encodeCertificate((Certificate)certificate);
    }

    public static CertificateRepresentation generateKeyPairCertificate(String subject) {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)subject);
        String privateKeyPem = PemUtils.encodeKey((Key)keyPair.getPrivate());
        String certPem = PemUtils.encodeCertificate((Certificate)certificate);
        CertificateRepresentation rep = new CertificateRepresentation();
        rep.setPrivateKey(privateKeyPem);
        rep.setCertificate(certPem);
        return rep;
    }

    public static UserCredentialModel generateSecret(ClientModel client) {
        UserCredentialModel secret = UserCredentialModel.generateSecret();
        client.setSecret(secret.getValue());
        return secret;
    }

    public static String getDefaultClientAuthenticatorType() {
        return "client-secret";
    }

    public static String generateCodeSecret() {
        return UUID.randomUUID().toString();
    }

    public static ClientModel createClient(RealmModel realm, String name) {
        ClientModel app = realm.addClient(name);
        app.setClientAuthenticatorType(KeycloakModelUtils.getDefaultClientAuthenticatorType());
        KeycloakModelUtils.generateSecret(app);
        app.setFullScopeAllowed(true);
        return app;
    }

    public static boolean searchFor(RoleModel role, RoleModel composite) {
        return composite.isComposite() && (composite.getComposites().contains(role) || composite.getComposites().stream().filter(x -> x.isComposite() && x.hasRole(role)).findFirst().isPresent());
    }

    public static UserModel findUserByNameOrEmail(KeycloakSession session, RealmModel realm, String username) {
        UserModel user;
        if (realm.isLoginWithEmailAllowed() && username.indexOf(64) != -1 && (user = session.users().getUserByEmail(username, realm)) != null) {
            return user;
        }
        return session.users().getUserByUsername(username, realm);
    }

    public static void runJobInTransaction(KeycloakSessionFactory factory, KeycloakSessionTask task) {
        KeycloakSession session = factory.create();
        KeycloakTransactionManager tx = session.getTransactionManager();
        try {
            tx.begin();
            task.run(session);
            if (tx.isActive()) {
                if (tx.getRollbackOnly()) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
        }
        catch (RuntimeException re) {
            if (tx.isActive()) {
                tx.rollback();
            }
            throw re;
        }
        finally {
            session.close();
        }
    }

    public static String getMasterRealmAdminApplicationClientId(String realmName) {
        return realmName + "-realm";
    }

    public static UserStorageProviderModel findUserStorageProviderByName(String displayName, RealmModel realm) {
        if (displayName == null) {
            return null;
        }
        for (UserStorageProviderModel fedProvider : realm.getUserStorageProviders()) {
            if (!displayName.equals(fedProvider.getName())) continue;
            return fedProvider;
        }
        return null;
    }

    public static UserStorageProviderModel findUserStorageProviderById(String fedProviderId, RealmModel realm) {
        for (UserStorageProviderModel fedProvider : realm.getUserStorageProviders()) {
            if (!fedProviderId.equals(fedProvider.getId())) continue;
            return fedProvider;
        }
        return null;
    }

    public static ComponentModel createComponentModel(String name, String parentId, String providerId, String providerType, String ... config) {
        ComponentModel mapperModel = new ComponentModel();
        mapperModel.setParentId(parentId);
        mapperModel.setName(name);
        mapperModel.setProviderId(providerId);
        mapperModel.setProviderType(providerType);
        String key = null;
        for (String configEntry : config) {
            if (key == null) {
                key = configEntry;
                continue;
            }
            mapperModel.getConfig().add((Object)key, (Object)configEntry);
            key = null;
        }
        if (key != null) {
            throw new IllegalStateException("Invalid count of arguments for config. Maybe mistake?");
        }
        return mapperModel;
    }

    public static String toLowerCaseSafe(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static void setupOfflineTokens(RealmModel realm) {
        if (realm.getRole("offline_access") == null) {
            RoleModel role = realm.addRole("offline_access");
            role.setDescription("${role_offline-access}");
            role.setScopeParamRequired(true);
            realm.addDefaultRole("offline_access");
        }
    }

    public static void deepFindAuthenticationExecutions(RealmModel realm, AuthenticationFlowModel flow, List<AuthenticationExecutionModel> result) {
        List executions = realm.getAuthenticationExecutions(flow.getId());
        for (AuthenticationExecutionModel execution : executions) {
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel subFlow = realm.getAuthenticationFlowById(execution.getFlowId());
                KeycloakModelUtils.deepFindAuthenticationExecutions(realm, subFlow, result);
                continue;
            }
            result.add(execution);
        }
    }

    public static String resolveFirstAttribute(GroupModel group, String name) {
        String value = group.getFirstAttribute(name);
        if (value != null) {
            return value;
        }
        if (group.getParentId() == null) {
            return null;
        }
        return KeycloakModelUtils.resolveFirstAttribute(group.getParent(), name);
    }

    public static String resolveFirstAttribute(UserModel user, String name) {
        String value = user.getFirstAttribute(name);
        if (value != null) {
            return value;
        }
        for (GroupModel group : user.getGroups()) {
            value = KeycloakModelUtils.resolveFirstAttribute(group, name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static List<String> resolveAttribute(GroupModel group, String name) {
        List values = group.getAttribute(name);
        if (values != null && !values.isEmpty()) {
            return values;
        }
        if (group.getParentId() == null) {
            return null;
        }
        return KeycloakModelUtils.resolveAttribute(group.getParent(), name);
    }

    public static List<String> resolveAttribute(UserModel user, String name) {
        List<String> values = user.getAttribute(name);
        if (!values.isEmpty()) {
            return values;
        }
        for (GroupModel group : user.getGroups()) {
            values = KeycloakModelUtils.resolveAttribute(group, name);
            if (values == null) continue;
            return values;
        }
        return Collections.emptyList();
    }

    private static GroupModel findSubGroup(String[] path, int index, GroupModel parent) {
        for (GroupModel group : parent.getSubGroups()) {
            if (!group.getName().equals(path[index])) continue;
            if (path.length == index + 1) {
                return group;
            }
            if (index + 1 < path.length) {
                GroupModel found = KeycloakModelUtils.findSubGroup(path, index + 1, group);
                if (found == null) continue;
                return found;
            }
            return null;
        }
        return null;
    }

    public static GroupModel findGroupByPath(RealmModel realm, String path) {
        String[] split;
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((split = path.split("/")).length == 0) {
            return null;
        }
        GroupModel found = null;
        for (GroupModel group : realm.getTopLevelGroups()) {
            if (!group.getName().equals(split[0])) continue;
            if (split.length == 1) {
                found = group;
                break;
            }
            if (split.length <= 1 || (found = KeycloakModelUtils.findSubGroup(split, 1, group)) == null) continue;
            break;
        }
        return found;
    }

    public static Set<RoleModel> getClientScopeMappings(ClientModel client, ScopeContainerModel container) {
        Set mappings = container.getScopeMappings();
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (RoleModel role : mappings) {
            RoleContainerModel roleContainer = role.getContainer();
            if (!(roleContainer instanceof ClientModel) || !client.getId().equals(((ClientModel)roleContainer).getId())) continue;
            result.add(role);
        }
        return result;
    }

    public static RoleModel getRoleFromString(RealmModel realm, String roleName) {
        String[] parsedRole = KeycloakModelUtils.parseRole(roleName);
        RoleModel role = null;
        if (parsedRole[0] == null) {
            role = realm.getRole(parsedRole[1]);
        } else {
            ClientModel client = realm.getClientByClientId(parsedRole[0]);
            if (client != null) {
                role = client.getRole(parsedRole[1]);
            }
        }
        return role;
    }

    public static String[] parseRole(String role) {
        int scopeIndex = role.lastIndexOf(46);
        if (scopeIndex > -1) {
            String appName = role.substring(0, scopeIndex);
            role = role.substring(scopeIndex + 1);
            String[] rtn = new String[]{appName, role};
            return rtn;
        }
        String[] rtn = new String[]{null, role};
        return rtn;
    }

    public static boolean isFlowUsed(RealmModel realm, AuthenticationFlowModel model) {
        AuthenticationFlowModel realmFlow = null;
        realmFlow = realm.getBrowserFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        realmFlow = realm.getRegistrationFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        realmFlow = realm.getClientAuthenticationFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        realmFlow = realm.getDirectGrantFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        realmFlow = realm.getResetCredentialsFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        for (IdentityProviderModel idp : realm.getIdentityProviders()) {
            if (model.getId().equals(idp.getFirstBrokerLoginFlowId())) {
                return true;
            }
            if (!model.getId().equals(idp.getPostBrokerLoginFlowId())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClientTemplateUsed(RealmModel realm, ClientTemplateModel template) {
        for (ClientModel client : realm.getClients()) {
            if (client.getClientTemplate() == null || !client.getClientTemplate().getId().equals(template.getId())) continue;
            return true;
        }
        return false;
    }

    public static ClientTemplateModel getClientTemplateByName(RealmModel realm, String templateName) {
        for (ClientTemplateModel clientTemplate : realm.getClientTemplates()) {
            if (!templateName.equals(clientTemplate.getName())) continue;
            return clientTemplate;
        }
        return null;
    }

    public static void setupAuthorizationServices(RealmModel realm) {
        for (String roleName : Constants.AUTHZ_DEFAULT_AUTHORIZATION_ROLES) {
            if (realm.getRole(roleName) != null) continue;
            RoleModel role = realm.addRole(roleName);
            role.setDescription("${role_" + roleName + "}");
            role.setScopeParamRequired(false);
            realm.addDefaultRole(roleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void suspendJtaTransaction(KeycloakSessionFactory factory, Runnable runnable) {
        JtaTransactionManagerLookup lookup = (JtaTransactionManagerLookup)factory.getProviderFactory(JtaTransactionManagerLookup.class);
        Transaction suspended = null;
        try {
            if (lookup != null && lookup.getTransactionManager() != null) {
                try {
                    suspended = lookup.getTransactionManager().suspend();
                }
                catch (SystemException e) {
                    throw new RuntimeException(e);
                }
            }
            runnable.run();
            if (suspended == null) return;
        }
        catch (Throwable throwable) {
            if (suspended == null) throw throwable;
            try {
                lookup.getTransactionManager().resume(suspended);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            lookup.getTransactionManager().resume(suspended);
            return;
        }
        catch (InvalidTransactionException e) {
            throw new RuntimeException(e);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getIdentityProviderDisplayName(KeycloakSession session, IdentityProviderModel provider) {
        String displayName = provider.getDisplayName();
        if (displayName != null && !displayName.isEmpty()) {
            return displayName;
        }
        SocialIdentityProviderFactory providerFactory = (SocialIdentityProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(SocialIdentityProvider.class, provider.getProviderId());
        if (providerFactory != null) {
            return providerFactory.getName();
        }
        return provider.getAlias();
    }
}

