/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import java.nio.charset.Charset;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.SecretKey;
import org.jboss.resteasy.jose.Base64Url;
import org.jboss.resteasy.jose.i18n.Messages;
import org.jboss.resteasy.jose.jwe.Algorithm;
import org.jboss.resteasy.jose.jwe.EncryptionMethod;
import org.jboss.resteasy.jose.jwe.JWEHeader;
import org.jboss.resteasy.jose.jwe.crypto.AES;
import org.jboss.resteasy.jose.jwe.crypto.AESCBC;
import org.jboss.resteasy.jose.jwe.crypto.AESGCM;
import org.jboss.resteasy.jose.jwe.crypto.DeflateHelper;
import org.jboss.resteasy.jose.jwe.crypto.RSA1_5;
import org.jboss.resteasy.jose.jwe.crypto.RSA_OAEP;

public class RSADecrypter {
    public static byte[] decrypt(JWEHeader readOnlyJWEHeader, String encodedHeader, String encodedEncryptedKey, String encodedIv, String encodedCipherText, String encodedAuthTag, RSAPrivateKey privateKey) {
        byte[] plainText;
        if (encodedEncryptedKey == null) {
            throw new RuntimeException(Messages.MESSAGES.encryptedKeyMustNotBeNull());
        }
        if (encodedIv == null) {
            throw new RuntimeException(Messages.MESSAGES.initializationVectorMustNotBeNull());
        }
        if (encodedAuthTag == null) {
            throw new RuntimeException(Messages.MESSAGES.authenticationTagMustNotBeNull());
        }
        Algorithm alg = readOnlyJWEHeader.getAlgorithm();
        SecretKey cek = null;
        byte[] encryptedKey = Base64Url.decode(encodedEncryptedKey);
        byte[] aad = encodedHeader.getBytes(Charset.forName("UTF-8"));
        byte[] iv = Base64Url.decode(encodedIv);
        byte[] cipherText = Base64Url.decode(encodedCipherText);
        byte[] authTag = Base64Url.decode(encodedAuthTag);
        if (alg.equals((Object)Algorithm.RSA1_5)) {
            int keyLength = readOnlyJWEHeader.getEncryptionMethod().getCekBitLength();
            SecretKey randomCEK = AES.generateKey(keyLength);
            try {
                cek = RSA1_5.decryptCEK(privateKey, encryptedKey, keyLength);
            }
            catch (Exception e) {
                cek = randomCEK;
            }
        } else if (alg.equals((Object)Algorithm.RSA_OAEP)) {
            cek = RSA_OAEP.decryptCEK(privateKey, encryptedKey);
        } else {
            throw new RuntimeException(Messages.MESSAGES.unsupportedJWEalgorithm());
        }
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        if (enc.equals((Object)EncryptionMethod.A128CBC_HS256) || enc.equals((Object)EncryptionMethod.A256CBC_HS512)) {
            plainText = AESCBC.decryptAuthenticated(cek, iv, cipherText, aad, authTag);
        } else if (enc.equals((Object)EncryptionMethod.A128GCM) || enc.equals((Object)EncryptionMethod.A256GCM)) {
            plainText = AESGCM.decrypt(cek, iv, cipherText, aad, authTag);
        } else {
            throw new RuntimeException(Messages.MESSAGES.unsupportedEncryptionMethod());
        }
        return DeflateHelper.applyDecompression(readOnlyJWEHeader.getCompressionAlgorithm(), plainText);
    }
}

