/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.messagedriven.DefaultResourceAdapterService;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class DefaultResourceAdapterWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final DefaultResourceAdapterWriteHandler INSTANCE = new DefaultResourceAdapterWriteHandler();

    private DefaultResourceAdapterWriteHandler() {
        super(new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateDefaultAdapterService(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateDefaultAdapterService(context, restored);
    }

    void updateDefaultAdapterService(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode adapterNameNode = EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME.resolveModelAttribute(context, model);
        String adapterName = adapterNameNode.isDefined() ? adapterNameNode.asString() : null;
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController existingDefaultRANameService = serviceRegistry.getService(DefaultResourceAdapterService.DEFAULT_RA_NAME_SERVICE_NAME);
        if (existingDefaultRANameService != null) {
            ((DefaultResourceAdapterService)existingDefaultRANameService.getValue()).setResourceAdapterName(adapterName);
        } else if (adapterName != null) {
            DefaultResourceAdapterService defaultResourceAdapterService = new DefaultResourceAdapterService(adapterName);
            ServiceController serviceController = context.getServiceTarget().addService(DefaultResourceAdapterService.DEFAULT_RA_NAME_SERVICE_NAME, (Service)defaultResourceAdapterService).install();
        }
    }
}

