/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfigService;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class StrictMaxPoolWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final StrictMaxPoolWriteHandler INSTANCE = new StrictMaxPoolWriteHandler();

    private StrictMaxPoolWriteHandler() {
        super(new AttributeDefinition[]{StrictMaxPoolResourceDefinition.MAX_POOL_SIZE, StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT, StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.applyModelToRuntime(context, operation, attributeName, model);
        return false;
    }

    private void applyModelToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode model) throws OperationFailedException {
        StrictMaxPoolConfigService smpc;
        String poolName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceName serviceName = StrictMaxPoolConfigService.EJB_POOL_CONFIG_BASE_SERVICE_NAME.append(new String[]{poolName});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController sc = registry.getService(serviceName);
        if (sc != null && (smpc = (StrictMaxPoolConfigService)sc.getService()) != null) {
            if (StrictMaxPoolResourceDefinition.MAX_POOL_SIZE.getName().equals(attributeName)) {
                int maxPoolSize = StrictMaxPoolResourceDefinition.MAX_POOL_SIZE.resolveModelAttribute(context, model).asInt(-1);
                smpc.setMaxPoolSize(maxPoolSize);
            } else if (StrictMaxPoolResourceDefinition.DERIVE_SIZE.getName().equals(attributeName)) {
                StrictMaxPoolConfigService.Derive derive = StrictMaxPoolResourceDefinition.parseDeriveSize(context, model);
                smpc.setDerive(derive);
            } else if (StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT.getName().equals(attributeName)) {
                long timeout = StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT.resolveModelAttribute(context, model).asLong();
                smpc.setTimeout(timeout);
            } else if (StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT.getName().equals(attributeName)) {
                String timeoutUnit = StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT.resolveModelAttribute(context, model).asString();
                smpc.setTimeoutUnit(TimeUnit.valueOf(timeoutUnit));
            }
        }
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.applyModelToRuntime(context, operation, attributeName, restored);
    }
}

