/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.handler.manager;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactHandlerManager.class)
public class DefaultArtifactHandlerManager
implements ArtifactHandlerManager {
    @Requirement(role=ArtifactHandler.class)
    private Map<String, ArtifactHandler> artifactHandlers;
    private Map<String, ArtifactHandler> unmanagedHandlers = new ConcurrentHashMap<String, ArtifactHandler>();

    @Override
    public ArtifactHandler getArtifactHandler(String type) {
        ArtifactHandler handler = this.unmanagedHandlers.get(type);
        if (handler == null && (handler = this.artifactHandlers.get(type)) == null) {
            handler = new DefaultArtifactHandler(type);
        }
        return handler;
    }

    @Override
    public void addHandlers(Map<String, ArtifactHandler> handlers) {
        this.unmanagedHandlers.putAll(handlers);
    }

    @Deprecated
    public Set<String> getHandlerTypes() {
        return this.artifactHandlers.keySet();
    }
}

