/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.HashMap;
import java.util.Map;

enum Namespace {
    UNKNOWN(null, false),
    EE_1_0("urn:jboss:domain:ee:1.0", true),
    EE_1_1("urn:jboss:domain:ee:1.1", true),
    EE_1_2("urn:jboss:domain:ee:1.2", false),
    EE_2_0("urn:jboss:domain:ee:2.0", true),
    EE_3_0("urn:jboss:domain:ee:3.0", false),
    EE_4_0("urn:jboss:domain:ee:4.0", false);

    public static final Namespace CURRENT;
    private final String name;
    private final boolean beanValidationIncluded;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name, boolean beanValidationIncluded) {
        this.name = name;
        this.beanValidationIncluded = beanValidationIncluded;
    }

    public String getUriString() {
        return this.name;
    }

    public boolean isBeanValidationIncluded() {
        return this.beanValidationIncluded;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = EE_4_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

