/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.id;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.AbstractCompositeIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.internal.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.service.ServiceRegistry;

public class EmbeddedIdMapper
extends AbstractCompositeIdMapper
implements SimpleIdMapperBuilder {
    private PropertyData idPropertyData;

    public EmbeddedIdMapper(PropertyData idPropertyData, Class compositeIdClass, ServiceRegistry serviceRegistry) {
        super(compositeIdClass, serviceRegistry);
        this.idPropertyData = idPropertyData;
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        for (IdMapper idMapper : this.ids.values()) {
            idMapper.mapToMapFromEntity(data, obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        if (obj == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.idPropertyData, this.getServiceRegistry());
        this.mapToMapFromId(data, getter.get(obj));
    }

    @Override
    public boolean mapToEntityFromMap(Object obj, Map data) {
        if (data == null || obj == null) {
            return false;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.idPropertyData, this.getServiceRegistry());
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.idPropertyData, this.getServiceRegistry());
        try {
            Object subObj = ReflectHelper.getDefaultConstructor((Class)getter.getReturnType()).newInstance(new Object[0]);
            boolean ret = true;
            for (IdMapper idMapper : this.ids.values()) {
                ret &= idMapper.mapToEntityFromMap(subObj, data);
            }
            if (ret) {
                setter.set(obj, subObj, null);
            }
            return ret;
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        EmbeddedIdMapper ret = new EmbeddedIdMapper(this.idPropertyData, this.compositeIdClass, this.getServiceRegistry());
        for (PropertyData propertyData : this.ids.keySet()) {
            String propertyName = propertyData.getName();
            ret.ids.put(propertyData, new SingleIdMapper(this.getServiceRegistry(), new PropertyData(prefix + propertyName, propertyData)));
        }
        return ret;
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        if (data == null) {
            return null;
        }
        Getter getter = ReflectionTools.getGetter(data.getClass(), this.idPropertyData, this.getServiceRegistry());
        return getter.get(data);
    }

    @Override
    public List<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        this.mapToMapFromId(data, obj);
        ArrayList<QueryParameterData> ret = new ArrayList<QueryParameterData>();
        for (Map.Entry propertyData : data.entrySet()) {
            ret.add(new QueryParameterData((String)propertyData.getKey(), propertyData.getValue()));
        }
        return ret;
    }
}

