/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.referenceable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.naming.NamingException;
import javax.naming.RefAddr;

public class SerializableObjectRefAddr
extends RefAddr {
    private static final long serialVersionUID = 9158134548376171898L;
    private final byte[] bytes;

    public SerializableObjectRefAddr(String type, Object content) throws NamingException {
        super(type);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(content);
            oos.flush();
            this.bytes = bos.toByteArray();
        }
        catch (IOException e) {
            throw new NamingException("Failed to serialize object:" + content + ", " + e.getMessage());
        }
    }

    @Override
    public Object getContent() {
        return this.bytes;
    }

    public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        return ois.readObject();
    }
}

