/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAResourceStore
implements ResourceStore {
    private final EntityManager entityManager;

    public JPAResourceStore(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public Resource create(String name, ResourceServer resourceServer, String owner) {
        if (!(resourceServer instanceof ResourceServerEntity)) {
            throw new RuntimeException("Unexpected type [" + resourceServer.getClass() + "].");
        }
        ResourceEntity entity = new ResourceEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setName(name);
        entity.setResourceServer((ResourceServerEntity)resourceServer);
        entity.setOwner(owner);
        this.entityManager.persist((Object)entity);
        return entity;
    }

    public void delete(String id) {
        Resource resource = (Resource)this.entityManager.find(ResourceEntity.class, (Object)id);
        resource.getScopes().clear();
        if (resource != null) {
            this.entityManager.remove((Object)resource);
        }
    }

    public Resource findById(String id, String resourceServerId) {
        if (id == null) {
            return null;
        }
        if (resourceServerId == null) {
            return (Resource)this.entityManager.find(ResourceEntity.class, (Object)id);
        }
        Query query = this.entityManager.createQuery("from ResourceEntity where resourceServer.id = :serverId and id = :id");
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("id", (Object)id);
        return (Resource)this.entityManager.find(ResourceEntity.class, (Object)id);
    }

    public List<Resource> findByOwner(String ownerId, String resourceServerId) {
        Query query = this.entityManager.createQuery("from ResourceEntity where resourceServer.id = :serverId and owner = :ownerId");
        query.setParameter("ownerId", (Object)ownerId);
        query.setParameter("serverId", (Object)resourceServerId);
        return query.getResultList();
    }

    public List<Resource> findByUri(String uri, String resourceServerId) {
        Query query = this.entityManager.createQuery("from ResourceEntity where resourceServer.id = :serverId and uri = :uri");
        query.setParameter("uri", (Object)uri);
        query.setParameter("serverId", (Object)resourceServerId);
        return query.getResultList();
    }

    public List findByResourceServer(String resourceServerId) {
        Query query = this.entityManager.createQuery("from ResourceEntity where resourceServer.id = :serverId");
        query.setParameter("serverId", (Object)resourceServerId);
        return query.getResultList();
    }

    public List findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(ResourceEntity.class);
        Root root = querybuilder.from(ResourceEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServerId));
        attributes.forEach((name, value) -> {
            if ("id".equals(name)) {
                predicates.add(root.get(name).in((Object[])value));
            } else if ("scope".equals(name)) {
                predicates.add(root.join("scopes").get("id").in((Object[])value));
            } else {
                predicates.add(builder.like(builder.lower((Expression)root.get(name)), "%" + value[0].toLowerCase() + "%"));
            }
        });
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResult != -1) {
            query.setMaxResults(maxResult);
        }
        return query.getResultList();
    }

    public List<Resource> findByScope(List<String> id, String resourceServerId) {
        Query query = this.entityManager.createQuery("select r from ResourceEntity r inner join r.scopes s where r.resourceServer.id = :serverId and (s.resourceServer.id = :serverId and s.id in (:scopeIds))");
        query.setParameter("scopeIds", id);
        query.setParameter("serverId", (Object)resourceServerId);
        return query.getResultList();
    }

    public Resource findByName(String name, String resourceServerId) {
        Query query = this.entityManager.createQuery("from ResourceEntity where resourceServer.id = :serverId and name = :name");
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("name", (Object)name);
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (Resource)result.get(0);
        }
        return null;
    }

    public List<Resource> findByType(String type, String resourceServerId) {
        Query query = this.entityManager.createQuery("from ResourceEntity r where r.resourceServer.id = :serverId and type = :type");
        query.setParameter("type", (Object)type);
        query.setParameter("serverId", (Object)resourceServerId);
        return query.getResultList();
    }
}

