/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.keycloak.authorization.permission.evaluator.Evaluators;
import org.keycloak.authorization.policy.evaluation.DefaultPolicyEvaluator;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;

public final class AuthorizationProvider
implements Provider {
    private final DefaultPolicyEvaluator policyEvaluator;
    private final Executor scheduller;
    private final Supplier<StoreFactory> storeFactory;
    private final Map<String, PolicyProviderFactory> policyProviderFactories;
    private final KeycloakSession keycloakSession;
    private final RealmModel realm;

    public AuthorizationProvider(KeycloakSession session, RealmModel realm, Supplier<StoreFactory> storeFactory, Map<String, PolicyProviderFactory> policyProviderFactories, Executor scheduller) {
        this.keycloakSession = session;
        this.realm = realm;
        this.storeFactory = storeFactory;
        this.scheduller = scheduller;
        this.policyProviderFactories = policyProviderFactories;
        this.policyEvaluator = new DefaultPolicyEvaluator(this);
    }

    public AuthorizationProvider(KeycloakSession session, RealmModel realm, StoreFactory storeFactory, Map<String, PolicyProviderFactory> policyProviderFactories) {
        this(session, realm, () -> storeFactory, policyProviderFactories, Runnable::run);
    }

    public Evaluators evaluators() {
        return new Evaluators(this.policyEvaluator, this.scheduller);
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory.get();
    }

    public Collection<PolicyProviderFactory> getProviderFactories() {
        return this.policyProviderFactories.values();
    }

    public <F extends PolicyProviderFactory> F getProviderFactory(String type) {
        return (F)this.policyProviderFactories.get(type);
    }

    public <P extends PolicyProvider> P getProvider(String type) {
        PolicyProviderFactory policyProviderFactory = this.policyProviderFactories.get(type);
        if (policyProviderFactory == null) {
            return null;
        }
        return (P)policyProviderFactory.create(this);
    }

    public KeycloakSession getKeycloakSession() {
        return this.keycloakSession;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void close() {
    }
}

