/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.OperationHandler;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.JChannelFactoryBuilderFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackOperation;
import org.jboss.as.clustering.jgroups.subsystem.StackOperationExecutor;
import org.jboss.as.clustering.jgroups.subsystem.StackProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class StackResourceDefinition
extends ChildResourceDefinition {
    public static final PathElement WILDCARD_PATH = StackResourceDefinition.pathElement("*");
    @Deprecated
    static final ObjectTypeAttributeDefinition TRANSPORT = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)TransportResourceDefinition.WILDCARD_PATH.getKey(), (AttributeDefinition[])new AttributeDefinition[]{ProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition(), TransportResourceDefinition.Attribute.SHARED.getDefinition(), ProtocolResourceDefinition.Attribute.SOCKET_BINDING.getDefinition(), TransportResourceDefinition.Attribute.DIAGNOSTICS_SOCKET_BINDING.getDefinition(), TransportResourceDefinition.ThreadingAttribute.DEFAULT_EXECUTOR.getDefinition(), TransportResourceDefinition.ThreadingAttribute.OOB_EXECUTOR.getDefinition(), TransportResourceDefinition.ThreadingAttribute.TIMER_EXECUTOR.getDefinition(), TransportResourceDefinition.ThreadingAttribute.THREAD_FACTORY.getDefinition(), TransportResourceDefinition.Attribute.SITE.getDefinition(), TransportResourceDefinition.Attribute.RACK.getDefinition(), TransportResourceDefinition.Attribute.MACHINE.getDefinition(), ProtocolResourceDefinition.Attribute.PROPERTIES.getDefinition()}).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).setAllowNull(true).setSuffix(null).build();
    @Deprecated
    static final ObjectTypeAttributeDefinition PROTOCOL = ObjectTypeAttributeDefinition.Builder.of((String)ProtocolResourceDefinition.WILDCARD_PATH.getKey(), (AttributeDefinition[])new AttributeDefinition[]{ProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition(), ProtocolResourceDefinition.Attribute.SOCKET_BINDING.getDefinition(), ProtocolResourceDefinition.Attribute.PROPERTIES.getDefinition()}).setAllowNull(true).setSuffix("protocol").build();
    @Deprecated
    static final AttributeDefinition PROTOCOLS = ((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"protocols", (ObjectTypeAttributeDefinition)PROTOCOL).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).setAllowNull(true).build();
    private final ResourceServiceBuilderFactory<ChannelFactory> builderFactory = new JChannelFactoryBuilderFactory();
    private final boolean allowRuntimeOnlyRegistration;

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"stack", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            ResourceTransformer transformer = new ResourceTransformer(){

                public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                    for (String name : resource.getChildrenNames(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                        resource.getModel().get(PROTOCOLS.getName()).add(name);
                    }
                    context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource).processChildren(resource);
                }
            };
            builder.setCustomResourceTransformer(transformer);
        }
        if (JGroupsModel.VERSION_2_0_0.requiresTransformation(version)) {
            builder.rejectChildResource(RelayResourceDefinition.PATH);
        } else {
            RelayResourceDefinition.buildTransformation(version, builder);
        }
        TransportResourceDefinition.buildTransformation(version, builder);
        ProtocolResourceDefinition.buildTransformation(version, builder);
    }

    public StackResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver(WILDCARD_PATH));
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addExtraParameters(new AttributeDefinition[]{TRANSPORT, PROTOCOLS});
        StackServiceHandler handler = new StackServiceHandler(this.builderFactory);
        new AddStepHandler((AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = context.getCurrentAddress();
                if (operation.hasDefined(TRANSPORT.getName())) {
                    ModelNode transport = operation.get(TRANSPORT.getName());
                    String type = ProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition().resolveModelAttribute(context, transport).asString();
                    PathElement transportPath = TransportResourceDefinition.pathElement(type);
                    PathAddress transportAddress = address.append(new PathElement[]{transportPath});
                    ModelNode transportOperation = Util.createAddOperation((PathAddress)transportAddress);
                    for (TransportResourceDefinition.Attribute attribute : TransportResourceDefinition.Attribute.values()) {
                        String name = attribute.getDefinition().getName();
                        if (!transport.hasDefined(name)) continue;
                        transportOperation.get(name).set(transport.get(name));
                    }
                    context.addStep(transportOperation, context.getResourceRegistration().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{transportPath}), "add"), OperationContext.Stage.MODEL);
                }
                if (operation.hasDefined(PROTOCOLS.getName())) {
                    for (ModelNode protocol : operation.get(PROTOCOLS.getName()).asList()) {
                        String type = ProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition().resolveModelAttribute(context, protocol).asString();
                        PathElement protocolPath = ProtocolResourceDefinition.pathElement(type);
                        PathAddress protocolAddress = address.append(new PathElement[]{protocolPath});
                        ModelNode protocolOperation = Util.createAddOperation((PathAddress)protocolAddress);
                        for (ProtocolResourceDefinition.Attribute attribute : ProtocolResourceDefinition.Attribute.values()) {
                            String name = attribute.getDefinition().getName();
                            if (!protocol.hasDefined(name)) continue;
                            protocolOperation.get(name).set(protocol.get(name));
                        }
                        context.addStep(protocolOperation, context.getResourceRegistration().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolPath}), "add"), OperationContext.Stage.MODEL);
                    }
                }
                super.execute(context, operation);
            }
        }.register(registration);
        new RemoveStepHandler((RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        SimpleOperationDefinition legacyAddProtocolOperation = new SimpleOperationDefinitionBuilder("add-protocol", this.getResourceDescriptionResolver()).setParameters(new AttributeDefinition[]{ProtocolResourceDefinition.Attribute.SOCKET_BINDING.getDefinition()}).addParameter(ProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition()).addParameter(ProtocolResourceDefinition.Attribute.PROPERTIES.getDefinition()).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion()).build();
        OperationStepHandler legacyAddProtocolHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                PathAddress address = context.getCurrentAddress();
                String protocol = operation.require(ProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition().getName()).asString();
                PathElement protocolPath = ProtocolResourceDefinition.pathElement(protocol);
                PathAddress protocolAddress = address.append(new PathElement[]{protocolPath});
                ModelNode protocolOperation = Util.createAddOperation((PathAddress)protocolAddress);
                for (ProtocolResourceDefinition.Attribute attribute : ProtocolResourceDefinition.Attribute.values()) {
                    String name = attribute.getDefinition().getName();
                    if (!operation.hasDefined(name)) continue;
                    protocolOperation.get(name).set(operation.get(name));
                }
                context.addStep(protocolOperation, context.getResourceRegistration().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolPath}), "add"), OperationContext.Stage.MODEL);
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyAddProtocolOperation, legacyAddProtocolHandler);
        SimpleOperationDefinition legacyRemoveProtocolOperation = new SimpleOperationDefinitionBuilder("remove-protocol", this.getResourceDescriptionResolver()).setParameters(new AttributeDefinition[]{ProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition()}).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion()).build();
        OperationStepHandler legacyRemoveProtocolHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                PathAddress address = context.getCurrentAddress();
                String protocol = operation.require(ProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition().getName()).asString();
                PathElement protocolPath = ProtocolResourceDefinition.pathElement(protocol);
                PathAddress protocolAddress = address.append(new PathElement[]{protocolPath});
                ModelNode removeOperation = Util.createRemoveOperation((PathAddress)protocolAddress);
                context.addStep(removeOperation, context.getResourceRegistration().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolPath}), "remove"), context.getCurrentStage());
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyRemoveProtocolOperation, legacyRemoveProtocolHandler);
        if (this.allowRuntimeOnlyRegistration) {
            new OperationHandler((OperationExecutor)new StackOperationExecutor(), StackOperation.class).register(registration);
        }
        new TransportResourceDefinition(this.builderFactory).register(registration);
        new StackProtocolResourceDefinition(this.builderFactory).register(registration);
        new RelayResourceDefinition(this.builderFactory).register(registration);
    }
}

