/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.services.bootstrap.WeldEjbServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.ejb.spi.helpers.ForwardingEjbServices;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

public class WeldInterceptorBindingsService
implements Service<InterceptorBindings> {
    private volatile InterceptorBindings interceptorBindings;
    private final InjectedValue<WeldBootstrapService> weldContainer = new InjectedValue();
    private final String beanArchiveId;
    private final String ejbName;
    private final Class<?> componentClass;
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldInterceptorBindingsService"});

    public WeldInterceptorBindingsService(String beanArchiveId, String ejbName, Class<?> componentClass) {
        this.beanArchiveId = beanArchiveId;
        this.ejbName = ejbName;
        this.componentClass = componentClass;
    }

    public void start(StartContext startContext) throws StartException {
        BeanManagerImpl beanManager = ((WeldBootstrapService)this.weldContainer.getValue()).getBeanManager(this.beanArchiveId);
        this.interceptorBindings = this.getInterceptorBindings(this.ejbName, beanManager);
    }

    protected InterceptorBindings getInterceptorBindings(String ejbName, BeanManagerImpl manager) {
        if (ejbName != null) {
            EjbServices ejbServices = (EjbServices)manager.getServices().get(EjbServices.class);
            if (ejbServices instanceof ForwardingEjbServices) {
                ejbServices = ((ForwardingEjbServices)ejbServices).delegate();
            }
            if (ejbServices instanceof WeldEjbServices) {
                return ((WeldEjbServices)ejbServices).getBindings(ejbName);
            }
        } else {
            InterceptionModel model;
            SlimAnnotatedType type = (SlimAnnotatedType)manager.createAnnotatedType(this.componentClass);
            if (!manager.getInterceptorModelRegistry().containsKey(type)) {
                EnhancedAnnotatedType enhancedType = ((ClassTransformer)manager.getServices().get(ClassTransformer.class)).getEnhancedAnnotatedType(type);
                InterceptionModelInitializer.of((BeanManagerImpl)manager, (EnhancedAnnotatedType)enhancedType, null).init();
            }
            if ((model = (InterceptionModel)manager.getInterceptorModelRegistry().get(type)) != null) {
                return new InterceptorBindingsAdapter((InterceptionModel)manager.getInterceptorModelRegistry().get(type));
            }
        }
        return null;
    }

    public void stop(StopContext stopContext) {
        this.interceptorBindings = null;
    }

    public InterceptorBindings getValue() throws IllegalStateException, IllegalArgumentException {
        return this.interceptorBindings;
    }

    public InjectedValue<WeldBootstrapService> getWeldContainer() {
        return this.weldContainer;
    }
}

