/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import java.util.ArrayList;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.keycloak.subsystem.server.extension.KeycloakAdapterConfigService;

public class KeycloakServerDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final String KEYCLOAK_CONFIG_PARAM_NAME = "org.keycloak.server-subsystem.Config";
    private static final ServiceName cacheContainerService = ServiceName.of((String[])new String[]{"jboss", "infinispan", "keycloak"});

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        KeycloakAdapterConfigService configService = KeycloakAdapterConfigService.INSTANCE;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        if (!configService.isKeycloakServerDeployment(deploymentName)) {
            return;
        }
        EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String webContext = configService.getWebContext();
        if (webContext == null) {
            throw new DeploymentUnitProcessingException("Can't determine web context/module for Keycloak Server");
        }
        description.setModuleName(webContext);
        this.addInfinispanCaches(phaseContext);
        this.addConfiguration(deploymentUnit, configService);
    }

    private void addConfiguration(DeploymentUnit deploymentUnit, KeycloakAdapterConfigService configService) throws DeploymentUnitProcessingException {
        ArrayList<ParamValueMetaData> contextParams;
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            throw new DeploymentUnitProcessingException("WarMetaData not found for KeycloakServer.");
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((contextParams = webMetaData.getContextParams()) == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(KEYCLOAK_CONFIG_PARAM_NAME);
        param.setParamValue(configService.getConfig().toString());
        contextParams.add(param);
        webMetaData.setContextParams(contextParams);
    }

    private void addInfinispanCaches(DeploymentPhaseContext context) {
        if (context.getServiceRegistry().getService(cacheContainerService) != null) {
            ServiceTarget st = context.getServiceTarget();
            st.addDependency(cacheContainerService);
            st.addDependency(cacheContainerService.append(new String[]{"realms"}));
            st.addDependency(cacheContainerService.append(new String[]{"users"}));
            st.addDependency(cacheContainerService.append(new String[]{"sessions"}));
            st.addDependency(cacheContainerService.append(new String[]{"offlineSessions"}));
            st.addDependency(cacheContainerService.append(new String[]{"loginFailures"}));
            st.addDependency(cacheContainerService.append(new String[]{"work"}));
            st.addDependency(cacheContainerService.append(new String[]{"authorization"}));
            st.addDependency(cacheContainerService.append(new String[]{"keys"}));
        }
    }

    public void undeploy(DeploymentUnit du) {
    }
}

