/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.LocalDateTimeJavaDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;

public class LocalDateTimeType
extends AbstractSingleColumnStandardBasicType<LocalDateTime>
implements VersionType<LocalDateTime>,
LiteralType<LocalDateTime> {
    public static final LocalDateTimeType INSTANCE = new LocalDateTimeType();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S", Locale.ENGLISH);

    public LocalDateTimeType() {
        super((SqlTypeDescriptor)TimestampTypeDescriptor.INSTANCE, (JavaTypeDescriptor)LocalDateTimeJavaDescriptor.INSTANCE);
    }

    public String getName() {
        return LocalDateTime.class.getSimpleName();
    }

    protected boolean registerUnderJavaType() {
        return true;
    }

    public String objectToSQLString(LocalDateTime value, Dialect dialect) throws Exception {
        return "{ts '" + FORMATTER.format(value) + "'}";
    }

    public LocalDateTime seed(SessionImplementor session) {
        return LocalDateTime.now();
    }

    public LocalDateTime next(LocalDateTime current, SessionImplementor session) {
        return LocalDateTime.now();
    }

    public Comparator<LocalDateTime> getComparator() {
        return ComparableComparator.INSTANCE;
    }
}

