/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.entities;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.connections.mongo.api.MongoCollection;
import org.keycloak.connections.mongo.api.MongoField;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.entities.MongoClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoClientTemplateEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoGroupEntity;
import org.keycloak.models.mongo.keycloak.entities.RoleEntity;

@MongoCollection(collectionName="roles")
public class MongoRoleEntity
extends RoleEntity
implements MongoIdentifiableEntity {
    private static final Logger logger = Logger.getLogger(MongoRoleEntity.class);

    @MongoField
    public String getNameIndex() {
        String realmId = this.getRealmId();
        String clientId = this.getClientId();
        String name = this.getName();
        if (realmId != null) {
            return realmId + "//" + name;
        }
        return clientId + "//" + name;
    }

    public void setNameIndex(String ignored) {
    }

    @Override
    public void afterRemove(MongoStoreInvocationContext invContext) {
        MongoStore mongoStore = invContext.getMongoStore();
        DBObject query = new QueryBuilder().and("roleIds").is((Object)this.getId()).get();
        List<MongoGroupEntity> groups = mongoStore.loadEntities(MongoGroupEntity.class, query, invContext);
        for (MongoGroupEntity mongoGroupEntity : groups) {
            mongoStore.pullItemFromList(mongoGroupEntity, "roleIds", this.getId(), invContext);
        }
        query = new QueryBuilder().and("scopeIds").is((Object)this.getId()).get();
        List<MongoClientEntity> clients = mongoStore.loadEntities(MongoClientEntity.class, query, invContext);
        for (MongoClientEntity mongoClientEntity : clients) {
            mongoStore.pullItemFromList(mongoClientEntity, "scopeIds", this.getId(), invContext);
        }
        List<MongoClientTemplateEntity> list = mongoStore.loadEntities(MongoClientTemplateEntity.class, query, invContext);
        for (MongoClientTemplateEntity clientTemplate : list) {
            mongoStore.pullItemFromList(clientTemplate, "scopeIds", this.getId(), invContext);
        }
        query = new QueryBuilder().and("compositeRoleIds").is((Object)this.getId()).get();
        List<MongoRoleEntity> list2 = mongoStore.loadEntities(MongoRoleEntity.class, query, invContext);
        for (MongoRoleEntity role : list2) {
            mongoStore.pullItemFromList(role, "compositeRoleIds", this.getId(), invContext);
        }
    }
}

