/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration;

import org.jboss.logging.Logger;
import org.keycloak.migration.MigrationModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.MigrateTo1_2_0;
import org.keycloak.migration.migrators.MigrateTo1_3_0;
import org.keycloak.migration.migrators.MigrateTo1_4_0;
import org.keycloak.migration.migrators.MigrateTo1_5_0;
import org.keycloak.migration.migrators.MigrateTo1_6_0;
import org.keycloak.migration.migrators.MigrateTo1_7_0;
import org.keycloak.migration.migrators.MigrateTo1_8_0;
import org.keycloak.migration.migrators.MigrateTo1_9_0;
import org.keycloak.migration.migrators.MigrateTo1_9_2;
import org.keycloak.migration.migrators.MigrateTo2_0_0;
import org.keycloak.migration.migrators.MigrateTo2_1_0;
import org.keycloak.migration.migrators.MigrateTo2_2_0;
import org.keycloak.migration.migrators.MigrateTo2_3_0;
import org.keycloak.migration.migrators.MigrateTo2_5_0;
import org.keycloak.migration.migrators.MigrateTo3_0_0;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;

public class MigrationModelManager {
    private static Logger logger = Logger.getLogger(MigrationModelManager.class);
    private static final Migration[] migrations = new Migration[]{new MigrateTo1_2_0(), new MigrateTo1_3_0(), new MigrateTo1_4_0(), new MigrateTo1_5_0(), new MigrateTo1_6_0(), new MigrateTo1_7_0(), new MigrateTo1_8_0(), new MigrateTo1_9_0(), new MigrateTo1_9_2(), new MigrateTo2_0_0(), new MigrateTo2_1_0(), new MigrateTo2_2_0(), new MigrateTo2_3_0(), new MigrateTo2_5_0(), new MigrateTo3_0_0()};

    public static void migrate(KeycloakSession session) {
        ModelVersion latest = migrations[migrations.length - 1].getVersion();
        MigrationModel model = session.realms().getMigrationModel();
        ModelVersion stored = null;
        if (model.getStoredVersion() != null && latest.equals(stored = new ModelVersion(model.getStoredVersion()))) {
            return;
        }
        for (Migration m : migrations) {
            if (stored != null && !stored.lessThan(m.getVersion())) continue;
            if (stored != null) {
                logger.debugf("Migrating older model to %s", (Object)m.getVersion());
            }
            m.migrate(session);
        }
        model.setStoredVersion(latest.toString());
    }
}

