/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.DefaultKeyProviders;

public class MigrateTo3_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("2.5.0");

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealms().stream().forEach(r -> DefaultKeyProviders.createSecretProvider(r));
        for (RealmModel realm : session.realms().getRealms()) {
            RoleModel manageAccount;
            ClientModel client = realm.getClientByClientId("account");
            if (client == null) continue;
            RoleModel linkRole = client.getRole("manage-account-links");
            if (linkRole == null) {
                client.addRole("manage-account-links");
            }
            if ((manageAccount = client.getRole("manage-account")) == null) continue;
            RoleModel manageAccountLinks = client.getRole("manage-account-links");
            manageAccount.addCompositeRole(manageAccountLinks);
        }
    }

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }
}

