/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewBindingInjectionSource;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.interceptors.ComponentDispatcherInterceptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public class ViewDescription {
    public static final int BRIDGE = 64;
    private final String viewClassName;
    private final ComponentDescription componentDescription;
    private final List<String> viewNameParts = new ArrayList<String>();
    private final Set<String> bindingNames = new HashSet<String>();
    private final Deque<ViewConfigurator> configurators = new ArrayDeque<ViewConfigurator>();
    private boolean serializable;
    private boolean useWriteReplace;
    public static final ImmediateInterceptorFactory CLIENT_DISPATCHER_INTERCEPTOR_FACTORY = new ImmediateInterceptorFactory(new Interceptor(){

        public Object processInvocation(InterceptorContext context) throws Exception {
            ComponentView view = (ComponentView)context.getPrivateData(ComponentView.class);
            return view.invoke(context);
        }
    });

    public ViewDescription(ComponentDescription componentDescription, String viewClassName) {
        this(componentDescription, viewClassName, true);
    }

    public ViewDescription(ComponentDescription componentDescription, String viewClassName, boolean defaultConfiguratorRequired) {
        this.componentDescription = componentDescription;
        this.viewClassName = viewClassName;
        if (defaultConfiguratorRequired) {
            this.configurators.addFirst(DefaultConfigurator.INSTANCE);
        }
        this.configurators.addFirst(ViewBindingConfigurator.INSTANCE);
    }

    public String getViewClassName() {
        return this.viewClassName;
    }

    public ComponentDescription getComponentDescription() {
        return this.componentDescription;
    }

    public List<String> getViewNameParts() {
        return this.viewNameParts;
    }

    public ServiceName getServiceName() {
        if (!this.viewNameParts.isEmpty()) {
            return this.componentDescription.getServiceName().append(new String[]{"VIEW"}).append(this.viewNameParts.toArray(new String[this.viewNameParts.size()]));
        }
        return this.componentDescription.getServiceName().append(new String[]{"VIEW"}).append(new String[]{this.viewClassName});
    }

    public ViewConfiguration createViewConfiguration(Class<?> viewClass, ComponentConfiguration componentConfiguration, ProxyFactory<?> proxyFactory) {
        return new ViewConfiguration(viewClass, componentConfiguration, this.getServiceName(), proxyFactory);
    }

    public Set<String> getBindingNames() {
        return this.bindingNames;
    }

    public Deque<ViewConfigurator> getConfigurators() {
        return this.configurators;
    }

    protected InjectionSource createInjectionSource(ServiceName serviceName, Value<ClassLoader> viewClassLoader) {
        return new ViewBindingInjectionSource(serviceName);
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    public boolean isUseWriteReplace() {
        return this.useWriteReplace;
    }

    public void setUseWriteReplace(boolean useWriteReplace) {
        this.useWriteReplace = useWriteReplace;
    }

    public String toString() {
        return "View of type " + this.viewClassName + " for " + this.componentDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewDescription that = (ViewDescription)o;
        if (this.componentDescription != that.componentDescription) {
            return false;
        }
        return !(this.viewClassName != null ? !this.viewClassName.equals(that.viewClassName) : that.viewClassName != null);
    }

    public int hashCode() {
        int result = this.viewClassName != null ? this.viewClassName.hashCode() : 0;
        result = 31 * result + (this.componentDescription != null ? this.componentDescription.hashCode() : 0);
        return result;
    }

    private static class ViewBindingConfigurator
    implements ViewConfigurator {
        public static final ViewBindingConfigurator INSTANCE = new ViewBindingConfigurator();

        private ViewBindingConfigurator() {
        }

        @Override
        public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
            List<BindingConfiguration> bindingConfigurations = configuration.getBindingConfigurations();
            for (String bindingName : description.getBindingNames()) {
                bindingConfigurations.add(new BindingConfiguration(bindingName, description.createInjectionSource(description.getServiceName(), (Value<ClassLoader>)Values.immediateValue((Object)componentConfiguration.getModuleClassLoader()))));
            }
        }
    }

    private static class DefaultConfigurator
    implements ViewConfigurator {
        public static final DefaultConfigurator INSTANCE = new DefaultConfigurator();

        private DefaultConfigurator() {
        }

        @Override
        public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
            DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
            List methods = configuration.getProxyFactory().getCachedMethods();
            for (Method method : methods) {
                Method other;
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)method);
                Method componentMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)reflectionIndex, componentConfiguration.getComponentClass(), (MethodIdentifier)methodIdentifier);
                if (componentMethod == null && method.getDeclaringClass().isInterface() && (method.getModifiers() & 0x409) == 1) {
                    componentMethod = method;
                }
                if (componentMethod == null) continue;
                if ((0x40 & componentMethod.getModifiers()) != 0 && (other = this.findRealMethodForBridgeMethod(componentMethod, componentConfiguration, reflectionIndex, methodIdentifier)) != null) {
                    componentMethod = other;
                }
                configuration.addViewInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ComponentDispatcherInterceptor(componentMethod)), 2560);
                configuration.addClientInterceptor(method, (InterceptorFactory)CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                configuration.getViewToComponentMethodMap().put(method, componentMethod);
            }
            configuration.addClientPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
            configuration.addClientPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
        }

        private Method findRealMethodForBridgeMethod(Method componentMethod, ComponentConfiguration componentConfiguration, DeploymentReflectionIndex reflectionIndex, MethodIdentifier methodIdentifier) {
            ClassReflectionIndex classIndex = reflectionIndex.getClassIndex(componentMethod.getDeclaringClass());
            Collection methods = classIndex.getAllMethods(componentMethod.getName(), componentMethod.getParameterTypes().length);
            for (Method method : methods) {
                if ((0x40 & method.getModifiers()) != 0 || !componentMethod.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                boolean ok = true;
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    if (componentMethod.getParameterTypes()[i].isAssignableFrom(method.getParameterTypes()[i])) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                return method;
            }
            return null;
        }
    }
}

