/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.ee.infinispan.Remover;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;

public class InfinispanSSO<A, D, L>
implements SSO<A, D, L> {
    private final String id;
    private final A authentication;
    private final Sessions<D> sessions;
    private final AtomicReference<L> localContext;
    private final LocalContextFactory<L> localContextFactory;
    private final Remover<String> remover;

    public InfinispanSSO(String id, A authentication, Sessions<D> sessions, AtomicReference<L> localContext, LocalContextFactory<L> localContextFactory, Remover<String> remover) {
        this.id = id;
        this.authentication = authentication;
        this.sessions = sessions;
        this.localContext = localContext;
        this.localContextFactory = localContextFactory;
        this.remover = remover;
    }

    public String getId() {
        return this.id;
    }

    public A getAuthentication() {
        return this.authentication;
    }

    public Sessions<D> getSessions() {
        return this.sessions;
    }

    public void invalidate() {
        this.remover.remove((Object)this.id);
    }

    public L getLocalContext() {
        if (this.localContextFactory == null) {
            return null;
        }
        Object localContext = this.localContext.get();
        if (localContext == null && !this.localContext.compareAndSet(null, localContext = this.localContextFactory.createLocalContext())) {
            return this.localContext.get();
        }
        return localContext;
    }
}

