/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.TrustType;
import org.picketlink.identity.federation.web.config.SecurityActions;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public class PropertiesConfigurationProvider
implements SAMLConfigurationProvider {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String IDP_FILE = "idp_config.properties";
    public static final String SP_FILE = "sp_config.properties";

    @Override
    public IDPType getIDPConfiguration() throws ProcessingException {
        InputStream is = SecurityActions.loadStream(this.getClass(), IDP_FILE);
        if (is == null) {
            throw logger.nullValueError(IDP_FILE);
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw logger.processingError((Throwable)e);
        }
        IDPType idp = new IDPType();
        idp.setIdentityURL(props.getProperty("idp.url"));
        String domains = props.getProperty("domains");
        if (StringUtil.isNotNull((String)domains)) {
            TrustType trustType = new TrustType();
            trustType.setDomains(domains);
            idp.setTrust(trustType);
        }
        return idp;
    }

    @Override
    public SPType getSPConfiguration() throws ProcessingException {
        InputStream is = SecurityActions.loadStream(this.getClass(), SP_FILE);
        if (is == null) {
            throw logger.nullValueError(SP_FILE);
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw logger.processingError((Throwable)e);
        }
        SPType sp = new SPType();
        sp.setIdentityURL(props.getProperty("idp.url"));
        sp.setServiceURL("service.url");
        String domains = props.getProperty("domains");
        if (StringUtil.isNotNull((String)domains)) {
            TrustType trustType = new TrustType();
            trustType.setDomains(domains);
            sp.setTrust(trustType);
        }
        return sp;
    }

    @Override
    public PicketLinkType getPicketLinkConfiguration() throws ProcessingException {
        return null;
    }
}

