/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;

public class EjbJarDescription {
    private final EEModuleDescription eeModuleDescription;
    private final Set<String> applicationLevelSecurityRoles = new HashSet<String>();
    private final EEApplicationClasses applicationClassesDescription;
    private final boolean war;

    public EjbJarDescription(EEModuleDescription eeModuleDescription, EEApplicationClasses applicationClassesDescription, boolean war) {
        this.war = war;
        if (eeModuleDescription == null) {
            throw EjbLogger.ROOT_LOGGER.paramCannotBeNull("EE module description");
        }
        this.eeModuleDescription = eeModuleDescription;
        this.applicationClassesDescription = applicationClassesDescription;
    }

    public void addSecurityRole(String role) {
        if (role == null || role.trim().isEmpty()) {
            throw EjbLogger.ROOT_LOGGER.stringParamCannotBeNullOrEmpty("Security role");
        }
        this.applicationLevelSecurityRoles.add(role);
    }

    public Set<String> getSecurityRoles() {
        return Collections.unmodifiableSet(this.applicationLevelSecurityRoles);
    }

    public boolean hasComponent(String componentName) {
        return this.eeModuleDescription.hasComponent(componentName);
    }

    public EEModuleDescription getEEModuleDescription() {
        return this.eeModuleDescription;
    }

    public Collection<SessionBeanComponentDescription> getSessionBeans() {
        ArrayList<SessionBeanComponentDescription> sessionBeans = new ArrayList<SessionBeanComponentDescription>();
        for (ComponentDescription componentDescription : this.eeModuleDescription.getComponentDescriptions()) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            sessionBeans.add((SessionBeanComponentDescription)componentDescription);
        }
        return sessionBeans;
    }

    public Collection<MessageDrivenComponentDescription> getMessageDrivenBeans() {
        ArrayList<MessageDrivenComponentDescription> mdbs = new ArrayList<MessageDrivenComponentDescription>();
        for (ComponentDescription componentDescription : this.eeModuleDescription.getComponentDescriptions()) {
            if (!(componentDescription instanceof MessageDrivenComponentDescription)) continue;
            mdbs.add((MessageDrivenComponentDescription)componentDescription);
        }
        return mdbs;
    }

    public void addSessionBeans(Collection<SessionBeanComponentDescription> sessionBeans) {
        for (SessionBeanComponentDescription sessionBean : sessionBeans) {
            this.eeModuleDescription.addComponent((ComponentDescription)sessionBean);
        }
    }

    public boolean isWar() {
        return this.war;
    }

    public EEApplicationClasses getApplicationClassesDescription() {
        return this.applicationClassesDescription;
    }
}

