/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.UserStorageProviderModel;

public class MigrateTo1_8_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.8.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        List realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            List federationProviders = realm.getUserStorageProviders();
            for (UserStorageProviderModel fedProvider : federationProviders) {
                if (!fedProvider.getProviderId().equals("ldap") || !this.isActiveDirectory(fedProvider) || MigrateTo1_8_0.getMapperByName(realm, (ComponentModel)fedProvider, "MSAD account controls") != null) continue;
                ComponentModel mapperModel = KeycloakModelUtils.createComponentModel("MSAD account controls", fedProvider.getId(), "msad-user-account-control-mapper", "org.keycloak.storage.ldap.mappers.LDAPStorageMapper", new String[0]);
                realm.addComponentModel(mapperModel);
            }
        }
    }

    public static ComponentModel getMapperByName(RealmModel realm, ComponentModel providerModel, String name) {
        List components = realm.getComponents(providerModel.getId(), "org.keycloak.storage.ldap.mappers.LDAPStorageMapper");
        for (ComponentModel component : components) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    private boolean isActiveDirectory(UserStorageProviderModel provider) {
        String vendor = (String)provider.getConfig().getFirst((Object)"vendor");
        return vendor != null && vendor.equals("ad");
    }
}

