/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQBytesMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQMapMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQObjectMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.UUID;

public class ActiveMQMessage
implements javax.jms.Message {
    public static final byte TYPE = 0;
    private static final HashSet<String> reservedIdentifiers = new HashSet();
    protected ClientMessage message;
    private ClientSession session;
    protected boolean readOnly;
    protected boolean propertiesReadOnly;
    private Destination dest;
    private String msgID;
    private Destination replyTo;
    private String jmsCorrelationID;
    private String jmsType;
    private boolean individualAck;
    private long jmsDeliveryTime;

    public static Map<String, Object> coreMaptoJMSMap(Map<String, Object> coreMessage) {
        HashMap<String, Object> jmsMessage = new HashMap<String, Object>();
        String deliveryMode = (Boolean)coreMessage.get("durable") != false ? "PERSISTENT" : "NON_PERSISTENT";
        byte priority = (Byte)coreMessage.get("priority");
        long timestamp = (Long)coreMessage.get("timestamp");
        long expiration = (Long)coreMessage.get("expiration");
        jmsMessage.put("JMSPriority", priority);
        jmsMessage.put("JMSTimestamp", timestamp);
        jmsMessage.put("JMSExpiration", expiration);
        jmsMessage.put("JMSDeliveryMode", deliveryMode);
        for (Map.Entry<String, Object> entry : coreMessage.entrySet()) {
            if (entry.getKey().equals("type") || entry.getKey().equals("durable") || entry.getKey().equals("expiration") || entry.getKey().equals("timestamp") || entry.getKey().equals("priority")) continue;
            if (entry.getKey().equals("userID")) {
                jmsMessage.put("JMSMessageID", entry.getValue().toString());
                continue;
            }
            Object value = entry.getValue();
            if (value instanceof SimpleString) {
                jmsMessage.put(entry.getKey(), value.toString());
                continue;
            }
            jmsMessage.put(entry.getKey(), value);
        }
        return jmsMessage;
    }

    public static ActiveMQMessage createMessage(ClientMessage message, ClientSession session) {
        ActiveMQMessage msg;
        byte type = message.getType();
        switch (type) {
            case 0: {
                msg = new ActiveMQMessage(message, session);
                break;
            }
            case 4: {
                msg = new ActiveMQBytesMessage(message, session);
                break;
            }
            case 5: {
                msg = new ActiveMQMapMessage(message, session);
                break;
            }
            case 2: {
                msg = new ActiveMQObjectMessage(message, session);
                break;
            }
            case 6: {
                msg = new ActiveMQStreamMessage(message, session);
                break;
            }
            case 3: {
                msg = new ActiveMQTextMessage(message, session);
                break;
            }
            default: {
                throw new JMSRuntimeException("Invalid message type " + type);
            }
        }
        return msg;
    }

    protected ActiveMQMessage(byte type, ClientSession session) {
        this.message = session.createMessage(type, true, 0L, System.currentTimeMillis(), (byte)4);
    }

    protected ActiveMQMessage(ClientSession session) {
        this(0, session);
    }

    public ActiveMQMessage(ClientMessage message, ClientSession session) {
        this.message = message;
        this.readOnly = true;
        this.propertiesReadOnly = true;
        this.session = session;
    }

    public ActiveMQMessage(javax.jms.Message foreign, ClientSession session) throws JMSException {
        this(foreign, 0, session);
    }

    public ActiveMQMessage() {
    }

    protected ActiveMQMessage(javax.jms.Message foreign, byte type, ClientSession session) throws JMSException {
        this(type, session);
        boolean supportBytesId;
        this.setJMSTimestamp(foreign.getJMSTimestamp());
        String value = System.getProperty("amq.jms.support-bytes-id");
        boolean bl = supportBytesId = !"false".equals(value);
        if (supportBytesId) {
            try {
                byte[] corrIDBytes = foreign.getJMSCorrelationIDAsBytes();
                this.setJMSCorrelationIDAsBytes(corrIDBytes);
            }
            catch (JMSException e) {
                String corrIDString = foreign.getJMSCorrelationID();
                if (corrIDString != null) {
                    this.setJMSCorrelationID(corrIDString);
                }
            }
        } else {
            String corrIDString = foreign.getJMSCorrelationID();
            if (corrIDString != null) {
                this.setJMSCorrelationID(corrIDString);
            }
        }
        this.setJMSReplyTo(foreign.getJMSReplyTo());
        this.setJMSDestination(foreign.getJMSDestination());
        this.setJMSDeliveryMode(foreign.getJMSDeliveryMode());
        this.setJMSExpiration(foreign.getJMSExpiration());
        this.setJMSPriority(foreign.getJMSPriority());
        this.setJMSType(foreign.getJMSType());
        Enumeration props = foreign.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            Object prop = foreign.getObjectProperty(name);
            this.setObjectProperty(name, prop);
        }
    }

    @Override
    public String getJMSMessageID() {
        if (this.msgID == null) {
            UUID uid = this.message.getUserID();
            this.msgID = uid == null ? null : "ID:" + uid.toString();
        }
        return this.msgID;
    }

    @Override
    public void setJMSMessageID(String jmsMessageID) throws JMSException {
        if (jmsMessageID != null && !jmsMessageID.startsWith("ID:")) {
            throw new JMSException("JMSMessageID must start with ID:");
        }
        this.message.setUserID(null);
        this.msgID = jmsMessageID;
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this.message.getTimestamp();
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.message.setTimestamp(timestamp);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return MessageUtil.getJMSCorrelationIDAsBytes(this.message);
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        try {
            MessageUtil.setJMSCorrelationIDAsBytes(this.message, correlationID);
        }
        catch (ActiveMQException e) {
            JMSException ex = new JMSException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public void setJMSCorrelationID(String correlationID) throws JMSException {
        MessageUtil.setJMSCorrelationID(this.message, correlationID);
        this.jmsCorrelationID = correlationID;
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        if (this.jmsCorrelationID == null) {
            this.jmsCorrelationID = MessageUtil.getJMSCorrelationID(this.message);
        }
        return this.jmsCorrelationID;
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        SimpleString repl;
        if (this.replyTo == null && (repl = MessageUtil.getJMSReplyTo(this.message)) != null) {
            this.replyTo = ActiveMQDestination.fromAddress(repl.toString());
        }
        return this.replyTo;
    }

    @Override
    public void setJMSReplyTo(Destination dest) throws JMSException {
        if (dest == null) {
            MessageUtil.setJMSReplyTo(this.message, null);
            this.replyTo = null;
        } else {
            if (!(dest instanceof ActiveMQDestination)) {
                throw new InvalidDestinationException("Foreign destination " + dest);
            }
            ActiveMQDestination jbd = (ActiveMQDestination)dest;
            MessageUtil.setJMSReplyTo(this.message, jbd.getSimpleAddress());
            this.replyTo = jbd;
        }
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        if (this.dest == null) {
            SimpleString sdest = this.message.getAddress();
            this.dest = sdest == null ? null : ActiveMQDestination.fromAddress(sdest.toString());
        }
        return this.dest;
    }

    @Override
    public void setJMSDestination(Destination destination) throws JMSException {
        this.dest = destination;
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return this.message.isDurable() ? 2 : 1;
    }

    @Override
    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode == 2) {
            this.message.setDurable(true);
        } else if (deliveryMode == 1) {
            this.message.setDurable(false);
        } else {
            throw ActiveMQJMSClientBundle.BUNDLE.illegalDeliveryMode(deliveryMode);
        }
    }

    @Override
    public boolean getJMSRedelivered() throws JMSException {
        return this.message.getDeliveryCount() > 1;
    }

    @Override
    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (!redelivered) {
            this.message.setDeliveryCount(1);
        } else if (this.message.getDeliveryCount() <= 1) {
            this.message.setDeliveryCount(2);
        }
    }

    @Override
    public void setJMSType(String type) throws JMSException {
        if (type != null) {
            MessageUtil.setJMSType(this.message, type);
            this.jmsType = type;
        }
    }

    @Override
    public String getJMSType() throws JMSException {
        if (this.jmsType == null) {
            this.jmsType = MessageUtil.getJMSType(this.message);
        }
        return this.jmsType;
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this.message.getExpiration();
    }

    @Override
    public void setJMSExpiration(long expiration) throws JMSException {
        this.message.setExpiration(expiration);
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return this.message.getPriority();
    }

    @Override
    public void setJMSPriority(int priority) throws JMSException {
        this.checkPriority(priority);
        this.message.setPriority((byte)priority);
    }

    @Override
    public void clearProperties() throws JMSException {
        MessageUtil.clearProperties(this.message);
        this.propertiesReadOnly = false;
    }

    @Override
    public void clearBody() throws JMSException {
        this.readOnly = false;
    }

    @Override
    public boolean propertyExists(String name) throws JMSException {
        return MessageUtil.propertyExists(this.message, name);
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        try {
            return this.message.getBooleanProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public byte getByteProperty(String name) throws JMSException {
        try {
            return this.message.getByteProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        try {
            return this.message.getShortProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public int getIntProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return this.message.getDeliveryCount();
        }
        try {
            return this.message.getIntProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return this.message.getDeliveryCount();
        }
        try {
            return this.message.getLongProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        try {
            return this.message.getFloatProperty(new SimpleString(name)).floatValue();
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        try {
            return this.message.getDoubleProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public String getStringProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return String.valueOf(this.message.getDeliveryCount());
        }
        try {
            if ("JMSXGroupID".equals(name)) {
                return this.message.getStringProperty(Message.HDR_GROUP_ID);
            }
            return this.message.getStringProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return String.valueOf(this.message.getDeliveryCount());
        }
        Object val = this.message.getObjectProperty(name);
        if (val instanceof SimpleString) {
            val = ((SimpleString)val).toString();
        }
        return val;
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        return Collections.enumeration(MessageUtil.getPropertyNames(this.message));
    }

    @Override
    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkProperty(name);
        this.message.putBooleanProperty(new SimpleString(name), value);
    }

    @Override
    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkProperty(name);
        this.message.putByteProperty(new SimpleString(name), value);
    }

    @Override
    public void setShortProperty(String name, short value) throws JMSException {
        this.checkProperty(name);
        this.message.putShortProperty(new SimpleString(name), value);
    }

    @Override
    public void setIntProperty(String name, int value) throws JMSException {
        this.checkProperty(name);
        this.message.putIntProperty(new SimpleString(name), value);
    }

    @Override
    public void setLongProperty(String name, long value) throws JMSException {
        this.checkProperty(name);
        this.message.putLongProperty(new SimpleString(name), value);
    }

    @Override
    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkProperty(name);
        this.message.putFloatProperty(new SimpleString(name), value);
    }

    @Override
    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkProperty(name);
        this.message.putDoubleProperty(new SimpleString(name), value);
    }

    @Override
    public void setStringProperty(String name, String value) throws JMSException {
        this.checkProperty(name);
        if ("JMSXGroupID".equals(name)) {
            this.message.putStringProperty(Message.HDR_GROUP_ID, SimpleString.toSimpleString(value));
        } else {
            this.message.putStringProperty(new SimpleString(name), SimpleString.toSimpleString(value));
        }
    }

    @Override
    public void setObjectProperty(String name, Object value) throws JMSException {
        if ("JMS_AMQ_OutputStream".equals(name)) {
            this.setOutputStream((OutputStream)value);
            return;
        }
        if ("JMS_AMQ_SaveStream".equals(name)) {
            this.saveToOutputStream((OutputStream)value);
            return;
        }
        this.checkProperty(name);
        if ("JMS_AMQ_InputStream".equals(name)) {
            this.setInputStream((InputStream)value);
            return;
        }
        try {
            this.message.putObjectProperty(new SimpleString(name), value);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this.session != null) {
            try {
                if (this.individualAck) {
                    this.message.individualAcknowledge();
                }
                this.session.commit();
            }
            catch (ActiveMQException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(e);
            }
        }
    }

    @Override
    public long getJMSDeliveryTime() throws JMSException {
        Long value;
        try {
            value = this.message.getLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
        }
        catch (Exception e) {
            return 0L;
        }
        if (value == null) {
            return 0L;
        }
        return value;
    }

    @Override
    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, deliveryTime);
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        if (this.isBodyAssignableTo(c)) {
            return this.getBodyInternal(c);
        }
        throw new MessageFormatException("Body not assignable to " + c);
    }

    protected <T> T getBodyInternal(Class<T> c) throws MessageFormatException {
        InputStream is = ((MessageInternal)((Object)this.message)).getBodyInputStream();
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        return true;
    }

    protected boolean hasNoBody() {
        return this.message.getBodySize() == 0;
    }

    public void setIndividualAcknowledge() {
        this.individualAck = true;
    }

    public void resetMessageID(String newMsgID) {
        this.msgID = newMsgID;
    }

    public ClientMessage getCoreMessage() {
        return this.message;
    }

    public void doBeforeSend() throws Exception {
        this.message.getBodyBuffer().resetReaderIndex();
    }

    public void checkBuffer() {
        this.message.getBodyBuffer();
    }

    public void doBeforeReceive() throws ActiveMQException {
        this.message.checkCompletion();
        ActiveMQBuffer body = this.message.getBodyBuffer();
        if (body != null) {
            body.resetReaderIndex();
        }
    }

    public byte getType() {
        return 0;
    }

    public void setInputStream(InputStream input) throws JMSException {
        this.checkStream();
        if (this.readOnly) {
            throw ActiveMQJMSClientBundle.BUNDLE.messageNotWritable();
        }
        this.message.setBodyInputStream(input);
    }

    public void setOutputStream(OutputStream output) throws JMSException {
        this.checkStream();
        if (!this.readOnly) {
            throw new IllegalStateException("OutputStream property is only valid on received messages");
        }
        try {
            this.message.setOutputStream(output);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void saveToOutputStream(OutputStream output) throws JMSException {
        this.checkStream();
        if (!this.readOnly) {
            throw new IllegalStateException("OutputStream property is only valid on received messages");
        }
        try {
            this.message.saveToOutputStream(output);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public boolean waitCompletionOnStream(long timeWait) throws JMSException {
        this.checkStream();
        try {
            return this.message.waitOutputStreamCompletion(timeWait);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ActiveMQMessage[");
        sb.append(this.getJMSMessageID());
        sb.append("]:");
        sb.append(this.message.isDurable() ? "PERSISTENT" : "NON-PERSISTENT");
        sb.append("/" + this.message.toString());
        return sb.toString();
    }

    protected void checkWrite() throws JMSException {
        if (this.readOnly) {
            throw ActiveMQJMSClientBundle.BUNDLE.messageNotWritable();
        }
    }

    protected void checkRead() throws JMSException {
        if (!this.readOnly) {
            throw ActiveMQJMSClientBundle.BUNDLE.messageNotReadable();
        }
    }

    private void checkStream() throws JMSException {
        if (this.message.getType() != 4 && this.message.getType() != 6) {
            throw ActiveMQJMSClientBundle.BUNDLE.onlyValidForByteOrStreamMessages();
        }
    }

    private void checkProperty(String name) throws JMSException {
        if (this.propertiesReadOnly) {
            if (name.equals("JMS_AMQ_InputStream")) {
                throw new MessageNotWriteableException("You cannot set the Input Stream on received messages. Did you mean JMS_AMQ_OutputStream or JMS_AMQ_SaveStream?");
            }
            throw ActiveMQJMSClientBundle.BUNDLE.messageNotWritable();
        }
        if (name == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullArgumentNotAllowed("property");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("The name of a property must not be an empty String.");
        }
        if (!this.isValidJavaIdentifier(name)) {
            throw ActiveMQJMSClientBundle.BUNDLE.invalidJavaIdentifier(name);
        }
        if (reservedIdentifiers.contains(name)) {
            throw new JMSRuntimeException("The property name '" + name + "' is reserved due to selector syntax.");
        }
        if (name.startsWith("JMS_ACTIVEMQ")) {
            throw new JMSRuntimeException("The property name '" + name + "' is illegal since it starts with JMS_ACTIVEMQ");
        }
    }

    private boolean isValidJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    private void checkPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new JMSException(priority + " is not valid: priority must be between 0 and 9");
        }
    }

    static {
        reservedIdentifiers.add("NULL");
        reservedIdentifiers.add("TRUE");
        reservedIdentifiers.add("FALSE");
        reservedIdentifiers.add("NOT");
        reservedIdentifiers.add("AND");
        reservedIdentifiers.add("OR");
        reservedIdentifiers.add("BETWEEN");
        reservedIdentifiers.add("LIKE");
        reservedIdentifiers.add("IN");
        reservedIdentifiers.add("IS");
        reservedIdentifiers.add("ESCAPE");
    }
}

