/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.infinispan.Cache;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.authorization.infinispan.InfinispanStoreFactoryProvider;
import org.keycloak.models.authorization.infinispan.entities.CachedScope;
import org.keycloak.models.cache.authorization.CachedStoreFactoryProvider;

public class CachedScopeStore
implements ScopeStore {
    private static final String SCOPE_ID_CACHE_PREFIX = "scp-id-";
    private static final String SCOPE_NAME_CACHE_PREFIX = "scp-name-";
    private final Cache<String, Map<String, List<CachedScope>>> cache;
    private final CachedStoreFactoryProvider cacheStoreFactory;
    private final InfinispanStoreFactoryProvider.CacheTransaction transaction;
    private ScopeStore delegate;
    private StoreFactory storeFactory;

    public CachedScopeStore(KeycloakSession session, CachedStoreFactoryProvider cacheStoreFactory, InfinispanStoreFactoryProvider.CacheTransaction transaction, StoreFactory delegate) {
        this.cacheStoreFactory = cacheStoreFactory;
        this.transaction = transaction;
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache("authorization");
        this.storeFactory = delegate;
    }

    public Scope create(String name, ResourceServer resourceServer) {
        Scope scope = this.getDelegate().create(name, this.getStoreFactory().getResourceServerStore().findById(resourceServer.getId()));
        this.transaction.whenRollback(() -> this.resolveResourceServerCache(resourceServer.getId()).remove(this.getCacheKeyForScope(scope.getId())));
        this.transaction.whenCommit(() -> this.invalidateCache(resourceServer.getId()));
        return this.createAdapter(new CachedScope(scope));
    }

    public void delete(String id) {
        Scope scope = this.getDelegate().findById(id, null);
        if (scope == null) {
            return;
        }
        ResourceServer resourceServer = scope.getResourceServer();
        this.getDelegate().delete(id);
        this.transaction.whenCommit(() -> this.invalidateCache(resourceServer.getId()));
    }

    public Scope findById(String id, String resourceServerId) {
        String cacheKeyForScope = this.getCacheKeyForScope(id);
        List<CachedScope> cached = this.resolveResourceServerCache(resourceServerId).get(cacheKeyForScope);
        if (cached == null) {
            Scope scope = this.getDelegate().findById(id, resourceServerId);
            if (scope != null) {
                CachedScope cachedScope = new CachedScope(scope);
                this.resolveResourceServerCache(resourceServerId).put(cacheKeyForScope, Arrays.asList(cachedScope));
                return this.createAdapter(cachedScope);
            }
            return null;
        }
        return this.createAdapter(cached.get(0));
    }

    public Scope findByName(String name, String resourceServerId) {
        String cacheKeyForScope = this.getCacheKeyForScopeName(name);
        List<CachedScope> cached = this.resolveResourceServerCache(resourceServerId).get(cacheKeyForScope);
        if (cached == null) {
            Scope scope = this.getDelegate().findByName(name, resourceServerId);
            if (scope != null) {
                this.resolveResourceServerCache(resourceServerId).put(cacheKeyForScope, Arrays.asList(new CachedScope(scope)));
                return this.findById(scope.getId(), resourceServerId);
            }
            return null;
        }
        return this.createAdapter(cached.get(0));
    }

    public List<Scope> findByResourceServer(String id) {
        return this.getDelegate().findByResourceServer(id);
    }

    public List<Scope> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        return this.getDelegate().findByResourceServer(attributes, resourceServerId, firstResult, maxResult);
    }

    private String getCacheKeyForScope(String id) {
        return SCOPE_ID_CACHE_PREFIX + id;
    }

    private String getCacheKeyForScopeName(String name) {
        return SCOPE_NAME_CACHE_PREFIX + name;
    }

    private ScopeStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.getStoreFactory().getScopeStore();
        }
        return this.delegate;
    }

    private StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    private Scope createAdapter(final CachedScope cached) {
        return new Scope(){
            private Scope updated;

            public String getId() {
                return cached.getId();
            }

            public String getName() {
                return cached.getName();
            }

            public void setName(String name) {
                this.getDelegateForUpdate().setName(name);
                cached.setName(name);
            }

            public String getIconUri() {
                return cached.getIconUri();
            }

            public void setIconUri(String iconUri) {
                this.getDelegateForUpdate().setIconUri(iconUri);
                cached.setIconUri(iconUri);
            }

            public ResourceServer getResourceServer() {
                return CachedScopeStore.this.getCachedStoreFactory().getResourceServerStore().findById(cached.getResourceServerId());
            }

            private Scope getDelegateForUpdate() {
                if (this.updated == null) {
                    this.updated = CachedScopeStore.this.getDelegate().findById(this.getId(), cached.getResourceServerId());
                    if (this.updated == null) {
                        throw new IllegalStateException("Not found in database");
                    }
                    CachedScopeStore.this.transaction.whenCommit(() -> CachedScopeStore.this.invalidateCache(cached.getResourceServerId()));
                    CachedScopeStore.this.transaction.whenRollback(() -> {
                        CachedScopeStore.this.resolveResourceServerCache(cached.getResourceServerId()).remove(CachedScopeStore.this.getCacheKeyForScope(cached.getId()));
                        CachedScopeStore.this.resolveResourceServerCache(cached.getResourceServerId()).remove(CachedScopeStore.this.getCacheKeyForScopeName(cached.getName()));
                    });
                }
                return this.updated;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || !Scope.class.isInstance(o)) {
                    return false;
                }
                Scope that = (Scope)o;
                return Objects.equals(this.getId(), that.getId());
            }

            public int hashCode() {
                return Objects.hash(this.getId());
            }
        };
    }

    private CachedStoreFactoryProvider getCachedStoreFactory() {
        return this.cacheStoreFactory;
    }

    private void invalidateCache(String resourceServerId) {
        this.cache.remove((Object)resourceServerId);
    }

    private Map<String, List<CachedScope>> resolveResourceServerCache(String id) {
        return (Map)this.cache.computeIfAbsent((Object)id, key -> new HashMap());
    }
}

