/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.transformer;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.util.CRLFOutputStream;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.impl.transformer.TransformIdentity;
import org.apache.xml.security.stax.impl.transformer.canonicalizer.Canonicalizer20010315_ExclOmitCommentsTransformer;

public class AttachmentContentSignatureTransform
extends TransformIdentity {
    public static final String ATTACHMENT = "attachment";
    private Attachment attachment;

    public XMLSecurityConstants.TransformMethod getPreferredTransformMethod(XMLSecurityConstants.TransformMethod forInput) {
        switch (forInput) {
            case XMLSecEvent: {
                return XMLSecurityConstants.TransformMethod.InputStream;
            }
            case InputStream: {
                return XMLSecurityConstants.TransformMethod.InputStream;
            }
        }
        throw new IllegalArgumentException("Unsupported class " + forInput.name());
    }

    public void setProperties(Map<String, Object> properties) throws XMLSecurityException {
        this.attachment = (Attachment)properties.get(ATTACHMENT);
    }

    protected Attachment getAttachment() {
        return this.attachment;
    }

    public void transform(XMLSecEvent xmlSecEvent) throws XMLStreamException {
        throw new UnsupportedOperationException("transform(XMLSecEvent) not allowed");
    }

    public void transform(InputStream inputStream) throws XMLStreamException {
        String mimeType = this.getAttachment().getMimeType();
        String lowerCaseMimeType = null;
        if (mimeType != null) {
            lowerCaseMimeType = mimeType.toLowerCase();
        }
        if (lowerCaseMimeType != null && (lowerCaseMimeType.startsWith("text/xml") || lowerCaseMimeType.startsWith("application/xml") || lowerCaseMimeType.matches("(application|image)/.*\\+xml.*"))) {
            Canonicalizer20010315_ExclOmitCommentsTransformer canon = new Canonicalizer20010315_ExclOmitCommentsTransformer();
            try {
                canon.setOutputStream(this.getOutputStream());
            }
            catch (XMLSecurityException e) {
                throw new XMLStreamException(e);
            }
            canon.transform(inputStream);
        } else if (lowerCaseMimeType != null && lowerCaseMimeType.startsWith("text/")) {
            CRLFOutputStream crlfOutputStream = new CRLFOutputStream(this.getOutputStream());
            try {
                this.setOutputStream((OutputStream)crlfOutputStream);
            }
            catch (XMLSecurityException e) {
                throw new XMLStreamException(e);
            }
            super.transform(inputStream);
        } else {
            super.transform(inputStream);
        }
    }
}

