/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import io.netty.channel.Channel;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import java.io.IOException;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.SimpleHttpUpgradeHandshake;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;
import org.xnio.netty.transport.WrappingXnioSocketChannel;

public class HTTPUpgradeService
implements Service<HTTPUpgradeService> {
    public static final ServiceName HTTP_UPGRADE_REGISTRY = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry"});
    public static final ServiceName UPGRADE_SERVICE_NAME = MessagingServices.JBOSS_MESSAGING_ACTIVEMQ.append(new String[]{"http-upgrade-service"});
    private final String activeMQServerName;
    private final String acceptorName;
    private final String httpListenerName;
    protected InjectedValue<ChannelUpgradeHandler> injectedRegistry = new InjectedValue();
    protected InjectedValue<ListenerRegistry> listenerRegistry = new InjectedValue();
    private ListenerRegistry.HttpUpgradeMetadata httpUpgradeMetadata;

    public HTTPUpgradeService(String activeMQServerName, String acceptorName, String httpListenerName) {
        this.activeMQServerName = activeMQServerName;
        this.acceptorName = acceptorName;
        this.httpListenerName = httpListenerName;
    }

    public static void installService(ServiceTarget serviceTarget, String activeMQServerName, String acceptorName, String httpListenerName) {
        HTTPUpgradeService service = new HTTPUpgradeService(activeMQServerName, acceptorName, httpListenerName);
        serviceTarget.addService(UPGRADE_SERVICE_NAME.append(new String[]{acceptorName}), (Service)service).addDependency(HTTP_UPGRADE_REGISTRY.append(new String[]{httpListenerName}), ChannelUpgradeHandler.class, service.injectedRegistry).addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, service.listenerRegistry).addDependency(ActiveMQActivationService.getServiceName(MessagingServices.getActiveMQServiceName(activeMQServerName))).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    public void start(StartContext context) throws StartException {
        ListenerRegistry.Listener listenerInfo = ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpListenerName);
        assert (listenerInfo != null);
        this.httpUpgradeMetadata = new ListenerRegistry.HttpUpgradeMetadata(this.getProtocol(), "core");
        listenerInfo.addHttpUpgradeMetadata(this.httpUpgradeMetadata);
        MessagingLogger.ROOT_LOGGER.registeredHTTPUpgradeHandler("activemq-remoting", this.acceptorName);
        ServiceController activeMQService = context.getController().getServiceContainer().getService(MessagingServices.getActiveMQServiceName(this.activeMQServerName));
        ActiveMQServer activeMQServer = (ActiveMQServer)ActiveMQServer.class.cast(activeMQService.getValue());
        ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).addProtocol(this.getProtocol(), HTTPUpgradeService.switchToMessagingProtocol(activeMQServer, this.acceptorName, this.getProtocol()), (HttpUpgradeHandshake)new SimpleHttpUpgradeHandshake("CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD", this.getSecKeyHeader(), this.getSecAcceptHeader()){

            public boolean handleUpgrade(HttpServerExchange exchange) throws IOException {
                if (super.handleUpgrade(exchange)) {
                    String endpoint = exchange.getRequestHeaders().getFirst(HTTPUpgradeService.this.getHttpUpgradeEndpointKey());
                    if (endpoint == null) {
                        return true;
                    }
                    return HTTPUpgradeService.this.acceptorName.equals(endpoint);
                }
                return false;
            }
        });
    }

    public void stop(StopContext context) {
        ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpListenerName).removeHttpUpgradeMetadata(this.httpUpgradeMetadata);
        this.httpUpgradeMetadata = null;
        ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).removeProtocol(this.getProtocol());
    }

    public HTTPUpgradeService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static ChannelListener<StreamConnection> switchToMessagingProtocol(final ActiveMQServer activemqServer, final String acceptorName, final String protocolName) {
        return new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection connection) {
                MessagingLogger.ROOT_LOGGER.debugf("Switching to %s protocol for %s http-acceptor", protocolName, acceptorName);
                WrappingXnioSocketChannel channel = new WrappingXnioSocketChannel(connection);
                RemotingService remotingService = activemqServer.getRemotingService();
                NettyAcceptor acceptor = (NettyAcceptor)remotingService.getAcceptor(acceptorName);
                acceptor.transfer((Channel)channel);
                connection.getSourceChannel().resumeReads();
            }
        };
    }

    protected String getProtocol() {
        return "activemq-remoting";
    }

    protected String getSecKeyHeader() {
        return "Sec-ActiveMQRemoting-Key";
    }

    protected String getSecAcceptHeader() {
        return "Sec-ActiveMQRemoting-Accept";
    }

    protected String getHttpUpgradeEndpointKey() {
        return "httpPpgradeEndpoint";
    }

    static class LegacyHttpUpgradeService
    extends HTTPUpgradeService {
        public static void installService(ServiceTarget serviceTarget, String activeMQServerName, String acceptorName, String httpListenerName) {
            LegacyHttpUpgradeService service = new LegacyHttpUpgradeService(activeMQServerName, acceptorName, httpListenerName);
            serviceTarget.addService(UPGRADE_SERVICE_NAME.append(new String[]{acceptorName, "legacy"}), (Service)service).addDependency(HTTP_UPGRADE_REGISTRY.append(new String[]{httpListenerName}), ChannelUpgradeHandler.class, (Injector)service.injectedRegistry).addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, (Injector)service.listenerRegistry).addDependency(ActiveMQActivationService.getServiceName(MessagingServices.getActiveMQServiceName(activeMQServerName))).setInitialMode(ServiceController.Mode.PASSIVE).install();
        }

        private LegacyHttpUpgradeService(String activeMQServerName, String acceptorName, String httpListenerName) {
            super(activeMQServerName, acceptorName, httpListenerName);
        }

        @Override
        protected String getProtocol() {
            return "hornetq-remoting";
        }

        @Override
        protected String getHttpUpgradeEndpointKey() {
            return "http-upgrade-endpoint";
        }

        @Override
        protected String getSecKeyHeader() {
            return "Sec-HornetQRemoting-Key";
        }

        @Override
        protected String getSecAcceptHeader() {
            return "Sec-HornetQRemoting-Accept";
        }
    }
}

