/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.as.domain.http.server.security.RealmIdentityManager;
import org.jboss.as.domain.management.AuthMechanism;

public class AuthenticationMechanismWrapper
implements AuthenticationMechanism {
    private final AuthenticationMechanism wrapped;
    private final AuthMechanism mechanism;

    public AuthenticationMechanismWrapper(AuthenticationMechanism wrapped, AuthMechanism mechanism) {
        this.wrapped = wrapped;
        this.mechanism = mechanism;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        try {
            this.initialiseRealmIdentityManager(exchange);
            AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = this.wrapped.authenticate(exchange, securityContext);
            return authenticationMechanismOutcome;
        }
        finally {
            RealmIdentityManager.clearRequestSpecific();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        try {
            this.initialiseRealmIdentityManager(exchange);
            AuthenticationMechanism.ChallengeResult challengeResult = this.wrapped.sendChallenge(exchange, securityContext);
            return challengeResult;
        }
        finally {
            RealmIdentityManager.clearRequestSpecific();
        }
    }

    private void initialiseRealmIdentityManager(HttpServerExchange exchange) {
        InetAddress inetAddress = null;
        SocketAddress address = exchange.getConnection().getPeerAddress();
        if (address instanceof InetSocketAddress) {
            inetAddress = ((InetSocketAddress)address).getAddress();
        }
        RealmIdentityManager.setRequestSpecific(this.mechanism, inetAddress);
    }
}

