/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.handlers.Handler;
import org.wildfly.extension.undertow.handlers.HandlerService;

class HandlerAdd
extends AbstractAddStepHandler {
    private Handler handler;

    HandlerAdd(Handler handler) {
        super(Handler.CAPABILITY, handler.getAttributes());
        this.handler = handler;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        HandlerService service = new HandlerService(this.handler.createHandler(context, model), name);
        ServiceTarget target = context.getServiceTarget();
        ServiceBuilder builder = target.addService(UndertowService.HANDLER.append(new String[]{name}), (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
        RuntimeCapability newCapability = Handler.CAPABILITY.fromBaseCapability(name);
        if (context.hasOptionalCapability("org.wildfly.request-controller", newCapability.getName(), null)) {
            builder.addDependency(RequestController.SERVICE_NAME, RequestController.class, service.getRequestControllerInjectedValue());
        }
        builder.install();
    }
}

